/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public enum PacketOption {
    FollowUpPacket(1),
    IsCompressed(2),
    Reattach(4);

    private static final PacketOption[] VALUES;
    private final int _value;

    public static Set<PacketOption> decode(int value) {
        EnumSet<PacketOption> packetOptions = EnumSet.noneOf(PacketOption.class);
        for (PacketOption packetOption : VALUES) {
            if ((value & packetOption.getValue()) == 0) continue;
            packetOptions.add(packetOption);
        }
        return packetOptions;
    }

    public static String getDisplayString(int value) {
        Set<PacketOption> packetOptions = PacketOption.decode(value);
        return value + (packetOptions.isEmpty() ? "(none)" : Arrays.toString(packetOptions.toArray()));
    }

    private PacketOption(int value) {
        if (Integer.numberOfTrailingZeros(value) != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    static {
        VALUES = PacketOption.values();
    }
}

