/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.packet.HPart;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;

@NotThreadSafe
public class HAuthenticationPart
extends HPart {
    private static final int NULL_VALUE_INDICATOR = -1;
    private static final int SPECIAL_NULL_VALUE_INDICATOR = -2;
    private static final int MAX_LENGTH_INDICATOR = -3;
    private static final int csp1_fi_max_1byte_length_C = 245;
    private static final int csp1_fi_max_length_C = 249;
    private static final int csp1_fi_special_null_C = 251;
    private static final int csp1_fi_null_value_C = 254;
    private static final int csp1_fi_2byte_length_C = 255;
    private final HRequestPacket _requestPacket;
    private final int _fieldCount;
    private int _currentFieldOffset;
    private int _currentFieldLength;
    private int _currentPhysicalFieldLength;
    private int _currentFieldIndex;
    private int _argumentCount;

    public static int getLengthIndicatorLength(int dataLen) {
        int len = dataLen <= 245 ? 1 : 3;
        return len;
    }

    public static int putLengthIndicator(int dataLen, byte[] buffer, int off) {
        if (dataLen <= 245) {
            ByteUtils.putByte(dataLen, buffer, off);
            return 1;
        }
        ByteUtils.putByte(246, buffer, off);
        ByteUtils.putShort(dataLen, buffer, off + 1);
        return 3;
    }

    public HAuthenticationPart(HRequestPacket requestPacket, int offset) {
        super(requestPacket.getRawPacketArray(), offset, -1, false, requestPacket.asciiStringOptimization());
        this._requestPacket = requestPacket;
        this._fieldCount = 0;
        this._currentFieldOffset = 0;
    }

    public HAuthenticationPart(byte[] packet, int offset, int length, boolean asciiStringOptimization) {
        super(packet, offset, length, true, asciiStringOptimization);
        this._requestPacket = null;
        this._fieldCount = this.getShort(0);
        this._currentFieldOffset = 2;
    }

    public HAuthenticationPart(HAuthenticationPart other) {
        super(other._packet, other._offset + other._currentFieldOffset, other._currentFieldLength, true, other._asciiStringOptimization);
        this._requestPacket = null;
        this._fieldCount = this.getShort(0);
        this._currentFieldOffset = 2;
    }

    public int size() {
        return this._length;
    }

    public byte[] getPartData() {
        return this.getBytes(0, this._length);
    }

    public void close() {
        this._checkModifiable();
        this._requestPacket._closePart(this._argumentCount, this._currentFieldOffset);
    }

    public boolean nextField() {
        if (this._currentFieldIndex >= this._fieldCount) {
            return false;
        }
        ++this._currentFieldIndex;
        if (this._currentPhysicalFieldLength > 0) {
            this._currentFieldOffset += this._currentPhysicalFieldLength;
        }
        this._currentFieldLength = this._currentPhysicalFieldLength = this._getFieldLength(this._currentFieldOffset);
        this._currentFieldOffset += this._currentFieldLength <= 245 ? 1 : 3;
        if (this._currentPhysicalFieldLength == -3) {
            this._currentPhysicalFieldLength = this.getShort(this._currentFieldOffset);
            this._currentFieldOffset += 2;
            this._currentFieldLength = this._getFieldLength(this._currentFieldOffset);
            if (this._currentFieldLength > 245) {
                this._currentFieldOffset += 3;
                this._currentPhysicalFieldLength -= 3;
            } else {
                ++this._currentFieldOffset;
                --this._currentPhysicalFieldLength;
            }
        }
        return true;
    }

    public int getCurrentFieldLength() {
        return this._currentFieldLength;
    }

    public int getValueAsUByte() {
        return this.getUByte(this._currentFieldOffset);
    }

    public String getValueAsString() {
        return this.getString(this._currentFieldOffset, this._currentFieldLength, false);
    }

    public byte[] getValueAsBytes() {
        return this.getBytes(this._currentFieldOffset, this._currentFieldLength);
    }

    public void addArg() {
        ++this._argumentCount;
    }

    public void addRow(int fieldCount) {
        this.putShort(fieldCount, this._currentFieldOffset);
        this._currentFieldOffset += 2;
    }

    public void addString(String value) {
        int len = Cesu8Utils.getByteLength(value);
        this._currentFieldOffset += this._putFieldLength(len, this._currentFieldOffset);
        this.putString(value, this._currentFieldOffset);
        this._currentFieldOffset += len;
    }

    public void addBytes(byte[] value) {
        int len = value.length;
        this._currentFieldOffset += this._putFieldLength(len, this._currentFieldOffset);
        this.putBytes(value, this._currentFieldOffset);
        this._currentFieldOffset += len;
    }

    public void addRawBytes(byte[] value) {
        int len = value.length;
        this.putBytes(value, this._currentFieldOffset);
        this._currentFieldOffset += len;
    }

    private int _getFieldLength(int offset) {
        int len = this.getUByte(offset);
        switch (len) {
            case 255: {
                return ByteUtils.getShortBigEndian(this._packet, this._offset + offset + 1);
            }
            case 246: {
                return this.getShort(offset + 1);
            }
            case 254: {
                return -1;
            }
            case 251: {
                return -2;
            }
            case 249: {
                return -3;
            }
        }
        if (len <= 245) {
            return len;
        }
        throw new AssertionError((Object)("Unexpected field length: " + len));
    }

    private int _putFieldLength(int len, int offset) {
        if (len <= 245) {
            this.putByte(len, offset);
            return 1;
        }
        this.putByte(246, offset);
        this.putShort(len, offset + 1);
        return 3;
    }
}

