/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.DriverSapDB;
import com.sap.db.jdbc.HanaConnection;
import com.sap.db.jdbc.HanaConnectionClean;
import com.sap.db.jdbc.HanaConnectionFinalize;
import com.sap.db.jdbc.HanaConnectionPhantom;
import com.sap.db.jdbc.trace.TraceControl;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ThreadSafe
public class Driver
extends DriverSapDB {
    public static final Driver INSTANCE;
    public static final TraceControl pptracer;

    public static Driver getInstance() {
        return INSTANCE;
    }

    public static Driver singleton() {
        return INSTANCE;
    }

    protected static ConnectionSapDB _createConnection(String string, Properties properties, ConnectionProperties connectionProperties) throws SQLException {
        HanaConnection hanaConnection = Driver._createPhantomClass(connectionProperties) ? HanaConnectionPhantom.newInstance(string, properties, connectionProperties) : (Driver._createCleanerClass(connectionProperties) ? HanaConnectionClean.newInstance(string, properties, connectionProperties) : (Driver._createFinalizerClass(connectionProperties) ? HanaConnectionFinalize.newInstance(string, properties, connectionProperties) : HanaConnection.newInstance(string, properties, connectionProperties)));
        return hanaConnection;
    }

    static {
        Driver.checkJavaVersionMinimum9();
        INSTANCE = new Driver();
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException sQLException) {
            System.err.println("Can't register driver: " + INSTANCE.getClass().getCanonicalName() + ": " + sQLException.getMessage());
        }
        pptracer = Driver.getTracer().getTraceControl();
    }
}

