/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.util.CSECipher;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.sql.SQLException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

@Immutable
public abstract class CSEBlockCipher
implements CSECipher {
    public static final int DEFAULT_IV_LENGTH = 16;
    public static final int DEFAULT_BLOCK_SIZE = 16;

    public abstract Key generateKey() throws SQLException;

    public abstract Key getKey(byte[] var1, String var2) throws SQLException;

    public abstract IvParameterSpec getRandomIv() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException;

    public abstract byte[] encrypt(Key var1, byte[] var2, IvParameterSpec var3) throws SQLException;

    public abstract byte[] encrypt(ColumnEncryptionKey var1, boolean var2, byte[] var3) throws SQLException;

    public abstract byte[] decrypt(ColumnEncryptionKey var1, byte[] var2, int var3, int var4) throws SQLException;

    public int getIVLength() {
        return 16;
    }

    public int getBlockSize() {
        return 16;
    }

    public int getEncryptedLength(int unencryptedLength) {
        return this.getIVLength() + (unencryptedLength / this.getBlockSize() + 1) * this.getBlockSize();
    }

    public IvParameterSpec getDeterministicIv(Key key, byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(key.getEncoded());
        md.update(input);
        return new IvParameterSpec(md.digest(), 0, this.getIVLength());
    }
}

