/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.ARIACBCImpl;
import java.security.InvalidKeyException;
import java.security.Key;

@Immutable
public class ARIAKey
implements Key {
    private static final long serialVersionUID = 789971686168568988L;
    private final byte[] _keyBytes;

    public ARIAKey(byte[] keyBytes) throws InvalidKeyException {
        if (keyBytes == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (!ARIACBCImpl.KeySize.isValidKeySizeInBytes(keyBytes.length)) {
            throw new InvalidKeyException(String.format("Invalid key size: %d", keyBytes.length));
        }
        this._keyBytes = keyBytes;
    }

    @Override
    public String getAlgorithm() {
        return "SAP_HANA_ARIA";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return this._keyBytes;
    }
}

