/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.NotThreadSafe;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

@NotThreadSafe
class RowSetParameter {
    private static final Object[] EMPTY_OPTIONS = new Object[0];
    private final JavaType _javaType;
    private final int _parameterIndex;
    private final String _parameterName;
    private final Object _value;
    private final Object[] _options;

    RowSetParameter(JavaType javaType, int parameterIndex, Object value) {
        this(javaType, parameterIndex, value, EMPTY_OPTIONS);
    }

    RowSetParameter(JavaType javaType, String parameterName, Object value) {
        this(javaType, parameterName, value, EMPTY_OPTIONS);
    }

    RowSetParameter(JavaType javaType, int parameterIndex, Object value, Object ... options) {
        this._javaType = javaType;
        this._parameterIndex = parameterIndex;
        this._parameterName = null;
        this._value = value;
        this._options = options;
    }

    RowSetParameter(JavaType javaType, String parameterName, Object value, Object ... options) {
        this._javaType = javaType;
        this._parameterIndex = -1;
        this._parameterName = parameterName;
        this._value = value;
        this._options = options;
    }

    void setValue(CallableStatement cs) throws SQLException {
        if (this._parameterIndex != -1) {
            this._javaType.setValue(cs, this._parameterIndex, this._value, this._options);
        } else {
            this._javaType.setValue(cs, this._parameterName, this._value, this._options);
        }
    }

    static enum JavaType {
        J_NULL{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setNull(parameterIndex, (int)((Integer)value));
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof String) {
                            cs.setNull(parameterIndex, (int)((Integer)value), (String)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setNull(parameterName, (int)((Integer)value));
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof String) {
                            cs.setNull(parameterName, (int)((Integer)value), (String)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_OBJECT{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setObject(parameterIndex, value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setObject(parameterIndex, value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    case 2: {
                        if (options[0] instanceof Integer && options[1] instanceof Integer) {
                            cs.setObject(parameterIndex, value, (int)((Integer)options[0]), (int)((Integer)options[1]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option types: " + options[0].getClass().getName() + " " + options[1].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setObject(parameterName, value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setObject(parameterName, value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    case 2: {
                        if (options[0] instanceof Integer && options[1] instanceof Integer) {
                            cs.setObject(parameterName, value, (int)((Integer)options[0]), (int)((Integer)options[1]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option types: " + options[0].getClass().getName() + " " + options[1].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_BOOLEAN{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setBoolean(parameterIndex, (boolean)((Boolean)value));
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setBoolean(parameterName, (boolean)((Boolean)value));
            }
        }
        ,
        J_BYTE{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setByte(parameterIndex, (byte)((Byte)value));
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setByte(parameterName, (byte)((Byte)value));
            }
        }
        ,
        J_SHORT{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setShort(parameterIndex, (short)((Short)value));
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setShort(parameterName, (short)((Short)value));
            }
        }
        ,
        J_INT{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setInt(parameterIndex, (int)((Integer)value));
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setInt(parameterName, (int)((Integer)value));
            }
        }
        ,
        J_LONG{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setLong(parameterIndex, (long)((Long)value));
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setLong(parameterName, (long)((Long)value));
            }
        }
        ,
        J_FLOAT{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setFloat(parameterIndex, ((Float)value).floatValue());
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setFloat(parameterName, ((Float)value).floatValue());
            }
        }
        ,
        J_DOUBLE{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setDouble(parameterIndex, (double)((Double)value));
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setDouble(parameterName, (double)((Double)value));
            }
        }
        ,
        J_BIGDECIMAL{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setBigDecimal(parameterIndex, (BigDecimal)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setBigDecimal(parameterName, (BigDecimal)value);
            }
        }
        ,
        J_DATE{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setDate(parameterIndex, (Date)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Calendar) {
                            cs.setDate(parameterIndex, (Date)value, (Calendar)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setDate(parameterName, (Date)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Calendar) {
                            cs.setDate(parameterName, (Date)value, (Calendar)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_TIME{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setTime(parameterIndex, (Time)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Calendar) {
                            cs.setTime(parameterIndex, (Time)value, (Calendar)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setTime(parameterName, (Time)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Calendar) {
                            cs.setTime(parameterName, (Time)value, (Calendar)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_TIMESTAMP{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setTimestamp(parameterIndex, (Timestamp)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Calendar) {
                            cs.setTimestamp(parameterIndex, (Timestamp)value, (Calendar)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setTimestamp(parameterName, (Timestamp)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Calendar) {
                            cs.setTimestamp(parameterName, (Timestamp)value, (Calendar)options[0]);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_STRING{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setString(parameterIndex, (String)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setString(parameterName, (String)value);
            }
        }
        ,
        J_NSTRING{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setNString(parameterIndex, (String)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setNString(parameterName, (String)value);
            }
        }
        ,
        J_BYTES{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setBytes(parameterIndex, (byte[])value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setBytes(parameterName, (byte[])value);
            }
        }
        ,
        J_CHARACTERSTREAM{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setCharacterStream(parameterIndex, (Reader)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setCharacterStream(parameterIndex, (Reader)value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setCharacterStream(parameterName, (Reader)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setCharacterStream(parameterName, (Reader)value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_NCHARACTERSTREAM{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setNCharacterStream(parameterIndex, (Reader)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setNCharacterStream(parameterIndex, (Reader)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setNCharacterStream(parameterName, (Reader)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setNCharacterStream(parameterName, (Reader)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_ASCIISTREAM{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setAsciiStream(parameterIndex, (InputStream)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setAsciiStream(parameterIndex, (InputStream)value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setAsciiStream(parameterName, (InputStream)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setAsciiStream(parameterName, (InputStream)value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_BINARYSTREAM{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setBinaryStream(parameterIndex, (InputStream)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setBinaryStream(parameterIndex, (InputStream)value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        cs.setBinaryStream(parameterName, (InputStream)value);
                        break;
                    }
                    case 1: {
                        if (options[0] instanceof Integer) {
                            cs.setBinaryStream(parameterName, (InputStream)value, (int)((Integer)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_URL{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setURL(parameterIndex, (URL)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                throw new AssertionError((Object)"Unexpected invocation");
            }
        }
        ,
        J_CLOB{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        if (value instanceof Clob) {
                            cs.setClob(parameterIndex, (Clob)value);
                            break;
                        }
                        if (value instanceof Reader) {
                            cs.setClob(parameterIndex, (Reader)value);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected value type: " + value.getClass().getName()));
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setClob(parameterIndex, (Reader)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        if (value instanceof Clob) {
                            cs.setClob(parameterName, (Clob)value);
                            break;
                        }
                        if (value instanceof Reader) {
                            cs.setClob(parameterName, (Reader)value);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected value type: " + value.getClass().getName()));
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setClob(parameterName, (Reader)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_NCLOB{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        if (value instanceof NClob) {
                            cs.setNClob(parameterIndex, (NClob)value);
                            break;
                        }
                        if (value instanceof Reader) {
                            cs.setNClob(parameterIndex, (Reader)value);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected value type: " + value.getClass().getName()));
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setNClob(parameterIndex, (Reader)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        if (value instanceof NClob) {
                            cs.setNClob(parameterName, (NClob)value);
                            break;
                        }
                        if (value instanceof Reader) {
                            cs.setNClob(parameterName, (Reader)value);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected value type: " + value.getClass().getName()));
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setNClob(parameterName, (Reader)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_BLOB{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        if (value instanceof Blob) {
                            cs.setBlob(parameterIndex, (Blob)value);
                            break;
                        }
                        if (value instanceof InputStream) {
                            cs.setBlob(parameterIndex, (InputStream)value);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected value type: " + value.getClass().getName()));
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setBlob(parameterIndex, (InputStream)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                switch (options.length) {
                    case 0: {
                        if (value instanceof Blob) {
                            cs.setBlob(parameterName, (Blob)value);
                            break;
                        }
                        if (value instanceof InputStream) {
                            cs.setBlob(parameterName, (InputStream)value);
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected value type: " + value.getClass().getName()));
                    }
                    case 1: {
                        if (options[0] instanceof Long) {
                            cs.setBlob(parameterName, (InputStream)value, (long)((Long)options[0]));
                            break;
                        }
                        throw new AssertionError((Object)("Unexpected option type: " + options[0].getClass().getName()));
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected options: " + Arrays.toString(options)));
                    }
                }
            }
        }
        ,
        J_ARRAY{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setArray(parameterIndex, (Array)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                throw new AssertionError((Object)"Unexpected invocation");
            }
        }
        ,
        J_REF{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setRef(parameterIndex, (Ref)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                throw new AssertionError((Object)"Unexpected invocation");
            }
        }
        ,
        J_ROWID{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setRowId(parameterIndex, (RowId)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setRowId(parameterName, (RowId)value);
            }
        }
        ,
        J_SQLXML{

            @Override
            void setValue(CallableStatement cs, int parameterIndex, Object value, Object[] options) throws SQLException {
                cs.setSQLXML(parameterIndex, (SQLXML)value);
            }

            @Override
            void setValue(CallableStatement cs, String parameterName, Object value, Object[] options) throws SQLException {
                cs.setSQLXML(parameterName, (SQLXML)value);
            }
        };


        abstract void setValue(CallableStatement var1, int var2, Object var3, Object[] var4) throws SQLException;

        abstract void setValue(CallableStatement var1, String var2, Object var3, Object[] var4) throws SQLException;
    }
}

