/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ClientRoutingInfo;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.SAPPassport;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.packet.BuildPlatform;
import com.sap.db.jdbc.packet.ClientContextOption;
import com.sap.db.jdbc.packet.ClientRoutingInfoDescriptionType;
import com.sap.db.jdbc.packet.ClientRoutingInfoType;
import com.sap.db.jdbc.packet.CommandInfo;
import com.sap.db.jdbc.packet.CommandOption;
import com.sap.db.jdbc.packet.CommitOption;
import com.sap.db.jdbc.packet.ConnectOption;
import com.sap.db.jdbc.packet.ConnectOptionFlagSet1;
import com.sap.db.jdbc.packet.DBConnectInfoOption;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.packet.DistributionProtocolVersion;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.MessageType;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.ProfileElement;
import com.sap.db.jdbc.packet.SegmentKind;
import com.sap.db.jdbc.packet.SessionContextOption;
import com.sap.db.jdbc.packet.StatementContextFlag;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.packet.XATransactionInfoOption;
import com.sap.db.jdbcext.XidSAP;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.StringUtils;
import com.sap.db.util.security.AbstractAuthenticationManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.transaction.xa.Xid;

@NotThreadSafe
public class HRequestPacket {
    public static final int DEFAULT_REQUEST_PACKET_SIZE = 0x100000;
    public static final int MAX_SEGMENT_COUNT = Short.MAX_VALUE;
    public static final int MINIMUM_SPACE_REMAINING = 4096;
    private static final boolean FILL_ON_INIT = false;
    private static final byte FILLER = -2;
    private static final long DUMMY_PROFILE_TIME = -1L;
    private static final String UNKNOWN_HOST_NAME = "unknown";
    private static final int MINIMUM_LOB_READ_CHUNK_SIZE = 200000;
    private final boolean _isPooled;
    private final List<Segment> _segments;
    private byte[] _packet;
    private MessageType _messageType;
    private int _packetLength;
    private short _segmentCount;
    private int _segmentIndex;
    private int _segmentOffset;
    private short _partCount;
    private int _partIndex;
    private int _partOffset;
    private int _argumentCount;
    private int _sendTimeOffset;
    private int _receiveTimeOffset;
    private int _passportOffset;
    private SAPPassport _passport;
    private int _passportConnectionCounter;
    private boolean _hasConnectionLevelClientRoutingInfoForStatementRouting;
    private boolean _hasConnectionLevelClientRoutingInfoForHintRouting;
    private static int _resizeCount;
    private static int _commandInfoPartCount;

    public static HRequestPacket newInstance(boolean isPooled, int size) {
        return new HRequestPacket(isPooled, size);
    }

    private HRequestPacket(boolean isPooled, int size) {
        this._isPooled = isPooled;
        this._segments = new ArrayList<Segment>(1);
        this._packet = new byte[PacketAnalyzer.align(size)];
        this._initPacket();
    }

    public boolean isPooled() {
        return this._isPooled;
    }

    public byte[] getRawPacketArray() {
        return this._packet;
    }

    public MessageType getMessageType() {
        return this._messageType;
    }

    public int getSize() {
        return this._packet.length;
    }

    public int getLength() {
        return this._packetLength;
    }

    public int getAvailableSpace() {
        int availableSpace = this._packet.length - this._packetLength;
        return availableSpace;
    }

    public int getArgumentCount() {
        return this._argumentCount;
    }

    public SAPPassport getPassport() {
        return this._passport;
    }

    public int getPassportConnectionCounter() {
        return this._passportConnectionCounter;
    }

    public boolean hasConnectionLevelClientRoutingInfoForStatementRouting() {
        return this._hasConnectionLevelClientRoutingInfoForStatementRouting;
    }

    public boolean hasConnectionLevelClientRoutingInfoForHintRouting() {
        return this._hasConnectionLevelClientRoutingInfoForHintRouting;
    }

    public void initDBConnectInfo(String databaseName, String networkGroup) {
        this._initPacket();
        this._newSegment(MessageType.DBConnectInfo, null, null);
        this._addDBConnectInfoPart(databaseName, networkGroup);
        this._closeSegment();
        this._closePacket();
    }

    public void addDBConnectInfoPart(String networkGroup) {
        this._addDBConnectInfoPart(null, networkGroup);
    }

    public void initAuthenticate(ConnectionSapDB connection) {
        this._initPacket();
        this._newSegment(MessageType.Authenticate, null, null);
        this._addClientContextPart(connection);
    }

    public HAuthenticationPart addAuthenticationPart() {
        this._newPart(PartKind.Authentication);
        return new HAuthenticationPart(this, this._packetLength);
    }

    public void initConnect(ConnectionSapDB connection, Session session, AbstractAuthenticationManager authenticationManager, String userName, String passwd, String x509, String userNameFromServer) throws SQLException {
        Session anchorSession = null;
        this._initPacket();
        this._newSegment(MessageType.Connect, null, null);
        if (connection != null && session != null && (anchorSession = connection.getSessionPool().getAnchorSession()) != null && !session.isWebSocketConnection() && connection.getEngineFeatures().supportSessionContextPartOnConnect()) {
            this._addSessionContextPart(connection);
        }
        HAuthenticationPart authenticationPart = this.addAuthenticationPart();
        authenticationManager.setClientProofPart(authenticationPart, StringUtils.stripUserName(userNameFromServer != null ? userNameFromServer : userName), passwd, x509);
        authenticationPart.close();
        this._addClientIDPart(connection.getTermID());
        this._addConnectOptionsPart(connection, session, anchorSession);
        this._closeSegment();
        this._closePacket();
    }

    public void initPing() {
        this._initPacket();
        this._newSegment(MessageType.Ping, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initExecuteDirect(ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, String sql, String commandInfoSource, int commandInfoLine, boolean isBatch) {
        int availableSpace;
        boolean addCommandInfoPart = commandInfoSource != null && commandInfoLine > 0;
        this._initPacket();
        this._newSegment(MessageType.ExecuteDirect, connection, session, resultSetHoldability, queryTimeout, null, EnumSet.of(SegmentFlags.NO_MINIMUM_SPACE_REMAINING_REQUIRED));
        int requiredSpace = PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(sql));
        if (addCommandInfoPart) {
            requiredSpace += PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(commandInfoSource) + 4);
        }
        if (requiredSpace > (availableSpace = this.getAvailableSpace())) {
            this._resize(this._packetLength + requiredSpace);
        }
        this._addCommandPart(sql);
        if (addCommandInfoPart) {
            this._addCommandInfoPart(commandInfoSource, commandInfoLine);
        }
        this._closeSegment();
        if (!isBatch) {
            this._closePacket();
        }
    }

    public boolean addExecuteDirectSegment(ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, String sql, String commandInfoSource, int commandInfoLine) {
        int availableSpace;
        if (this._segmentCount >= Short.MAX_VALUE) {
            return false;
        }
        byte[] statementContext = connection.getStatementContext();
        boolean addStatementSequenceInfo = statementContext != null;
        boolean addQueryTimeout = connection.getEngineFeatures().isQueryTimeoutSupported() && queryTimeout > 0;
        boolean addCommandInfoPart = commandInfoSource != null && commandInfoLine > 0;
        int requiredSpace = 24;
        if (addStatementSequenceInfo || addQueryTimeout) {
            requiredSpace += 16;
            if (addStatementSequenceInfo) {
                requiredSpace += statementContext.length + 4;
            }
            if (addQueryTimeout) {
                requiredSpace += 10;
            }
            requiredSpace = PacketAnalyzer.align(requiredSpace);
        }
        requiredSpace += PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(sql));
        if (addCommandInfoPart) {
            requiredSpace += PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(commandInfoSource) + 4);
        }
        if (requiredSpace > (availableSpace = this.getAvailableSpace())) {
            return false;
        }
        this._newSegment(MessageType.ExecuteDirect, connection, session, resultSetHoldability, queryTimeout, null, EnumSet.of(SegmentFlags.IS_ADDITIONAL_SEGMENT));
        this._addCommandPart(sql);
        if (addCommandInfoPart) {
            this._addCommandInfoPart(commandInfoSource, commandInfoLine);
        }
        this._closeSegment();
        return true;
    }

    public void initPrepare(ConnectionSapDB connection, Session session, int resultSetHoldability, String sql, boolean fullCompileOnPrepare, byte[] transactionID, String commandInfoSource, int commandInfoLine) {
        int availableSpace;
        boolean addCommandInfoPart = commandInfoSource != null && commandInfoLine > 0;
        EnumSet<SegmentFlags> segmentFlags = EnumSet.of(SegmentFlags.NO_MINIMUM_SPACE_REMAINING_REQUIRED);
        if (fullCompileOnPrepare) {
            segmentFlags.add(SegmentFlags.FULL_COMPILE_ON_PREPARE);
        }
        this._initPacket();
        this._newSegment(MessageType.Prepare, connection, session, resultSetHoldability, 0, null, segmentFlags);
        if (transactionID != null) {
            this._addTransactionIDPart(transactionID);
        }
        int requiredSpace = PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(sql));
        if (addCommandInfoPart) {
            requiredSpace += PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(commandInfoSource) + 4);
        }
        if (requiredSpace > (availableSpace = this.getAvailableSpace())) {
            this._resize(this._packetLength + requiredSpace);
        }
        this._addCommandPart(sql);
        if (addCommandInfoPart) {
            this._addCommandInfoPart(commandInfoSource, commandInfoLine);
        }
        this._closeSegment();
        this._closePacket();
    }

    public void initPrepareAndExecute(ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, String sql, String commandInfoSource, int commandInfoLine, List<ClientRoutingInfo> clientRoutingInfos) {
        int availableSpace;
        boolean addCommandInfoPart = commandInfoSource != null && commandInfoLine > 0;
        boolean addClientRoutingInfoPart = !clientRoutingInfos.isEmpty();
        EnumSet<SegmentFlags> segmentFlags = EnumSet.of(SegmentFlags.NO_MINIMUM_SPACE_REMAINING_REQUIRED);
        this._initPacket();
        this._newSegment(MessageType.PrepareAndExecute, connection, session, resultSetHoldability, queryTimeout, null, segmentFlags);
        int requiredSpace = PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(sql));
        if (addCommandInfoPart) {
            requiredSpace += PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(commandInfoSource) + 4);
        }
        if (addClientRoutingInfoPart) {
            requiredSpace += this._getRequiredSpaceForClientRoutingInfos(clientRoutingInfos);
        }
        if (requiredSpace > (availableSpace = this.getAvailableSpace())) {
            this._resize(this._packetLength + requiredSpace);
        }
        this._addCommandPart(sql);
        if (addCommandInfoPart) {
            this._addCommandInfoPart(commandInfoSource, commandInfoLine);
        }
        if (addClientRoutingInfoPart) {
            this._addClientRoutingInfoPart(clientRoutingInfos);
        }
    }

    public void initExecute(ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, ParseID parseID, byte[] transactionID, String commandInfoSource, int commandInfoLine, List<ClientRoutingInfo> clientRoutingInfos) {
        int availableSpace;
        boolean addCommandInfoPart = commandInfoSource != null && commandInfoLine > 0;
        boolean addClientRoutingInfoPart = !clientRoutingInfos.isEmpty();
        this._initPacket();
        this._newSegment(MessageType.Execute, connection, session, resultSetHoldability, queryTimeout, parseID, EnumSet.noneOf(SegmentFlags.class));
        if (transactionID != null) {
            this._addTransactionIDPart(transactionID);
        }
        this._addStatementIDPart(parseID);
        int requiredSpace = 0;
        if (addCommandInfoPart) {
            requiredSpace += PacketAnalyzer.align(16 + Cesu8Utils.getByteLength(commandInfoSource) + 4);
        }
        if (addClientRoutingInfoPart) {
            requiredSpace += this._getRequiredSpaceForClientRoutingInfos(clientRoutingInfos);
        }
        if (requiredSpace > (availableSpace = this.getAvailableSpace())) {
            this._resize(this._packetLength + requiredSpace);
        }
        if (addCommandInfoPart) {
            this._addCommandInfoPart(commandInfoSource, commandInfoLine);
        }
        if (addClientRoutingInfoPart) {
            this._addClientRoutingInfoPart(clientRoutingInfos);
        }
    }

    public HDataPart addParametersPart() {
        this._newPart(PartKind.Parameters);
        return HDataPart.createParametersPart(this, this._packetLength);
    }

    public void initReadLOB(ConnectionSapDB connection, Session session, byte[] locatorID, long position, int packetSize) {
        this._initPacket();
        this._newSegment(MessageType.ReadLOB, connection, session);
        this._addReadLOBRequestPart(locatorID, position, packetSize);
        this._closeSegment();
        this._closePacket();
    }

    public void initWriteLOB(ConnectionSapDB connection, Session session) {
        this._initPacket();
        this._newSegment(MessageType.WriteLOB, connection, session);
    }

    public HDataPart addWriteLOBRequestPart() {
        this._newPart(PartKind.WriteLOBRequest);
        return HDataPart.createWriteLobRequestPart(this, this._packetLength);
    }

    public void initFetchNext(ConnectionSapDB connection, Session session, CursorID cursorID, int fetchSize) {
        this._initPacket();
        this._newSegment(MessageType.FetchNext, connection, session);
        this._addResultSetIDPart(cursorID);
        this._addFetchSizePart(fetchSize);
        this._closeSegment();
        this._closePacket();
    }

    public void initCloseResultSet(ConnectionSapDB connection, Session session, CursorID cursorID) {
        this._initPacket();
        this._newSegment(MessageType.CloseResultSet, connection, session);
        this._addResultSetIDPart(cursorID);
        this._closeSegment();
        this._closePacket();
    }

    public void initDropStatementID(ConnectionSapDB connection, Session session, ParseID parseID) {
        this._initPacket();
        this._newSegment(MessageType.DropStatementID, connection, session);
        this._addStatementIDPart(parseID);
        this._closeSegment();
        this._closePacket();
    }

    public void initCommit(ConnectionSapDB connection, Session session) {
        this._initPacket();
        this._newSegment(MessageType.Commit, connection, session);
        this._addCommitOptionsPart();
        this._closeSegment();
        this._closePacket();
    }

    public void initRollback(ConnectionSapDB connection, Session session) {
        this._initPacket();
        this._newSegment(MessageType.Rollback, connection, session);
        this._closeSegment();
        this._closePacket();
    }

    public void initStartDistributedTransaction(ConnectionSapDB connection, Session session) {
        this._initPacket();
        this._newSegment(MessageType.XA_Start, connection, session);
        this._closeSegment();
        this._closePacket();
    }

    public void initJoinDistributedTransaction(ConnectionSapDB connection, Session session, byte[] transactionID) {
        this._initPacket();
        this._newSegment(MessageType.XA_Join, connection, session);
        this._addTransactionIDPart(transactionID);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAStart(ConnectionSapDB connection, Session session, Xid xid, int flags) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAStart, connection, session);
        this._addXATransactionInfoPart(xid, flags, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAEnd(ConnectionSapDB connection, Session session, Xid xid, int flags) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAEnd, connection, session);
        this._addXATransactionInfoPart(xid, flags, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAPrepare(ConnectionSapDB connection, Session session, Xid xid) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAPrepare, connection, session);
        this._addXATransactionInfoPart(xid, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXACommit(ConnectionSapDB connection, Session session, Xid xid, boolean onePhase) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XACommit, connection, session);
        this._addXATransactionInfoPart(xid, null, onePhase);
        this._closeSegment();
        this._closePacket();
    }

    public void initXARollback(ConnectionSapDB connection, Session session, Xid xid) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XARollback, connection, session);
        this._addXATransactionInfoPart(xid, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXARecover(ConnectionSapDB connection, Session session, int flags) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XARecover, connection, session);
        this._addXATransactionInfoPart(null, flags, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAForget(ConnectionSapDB connection, Session session, Xid xid) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAForget, connection, session);
        this._addXATransactionInfoPart(xid, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public void addPartAttribute(PartAttribute partAttribute) {
        int offset = this._partOffset + 1;
        byte currentAttributes = ByteUtils.getByte(this._packet, offset);
        int newAttributes = currentAttributes | partAttribute.getValue();
        ByteUtils.putByte(newAttributes, this._packet, offset);
    }

    public void setAutoCommit(boolean autoCommit) {
        ByteUtils.putByte(autoCommit ? 1 : 0, this._packet, this._segmentOffset + 14);
    }

    public void setStatementContextAndProfileTimes(byte[] statementContext, long sendTime, long receiveTime) {
        if (statementContext != null) {
            for (Segment segment : this._segments) {
                if (segment._statementContextOffset == -1) continue;
                ByteUtils.putBytes(statementContext, this._packet, segment._statementContextOffset);
            }
        }
        if (this._sendTimeOffset != -1) {
            ByteUtils.putLong(sendTime / 1000L, this._packet, this._sendTimeOffset);
        }
        if (this._receiveTimeOffset != -1) {
            ByteUtils.putLong(receiveTime / 1000L, this._packet, this._receiveTimeOffset);
        }
    }

    public boolean setPassportConnectionCounter(int connectionCounter) {
        if (this._passportOffset == -1) {
            return false;
        }
        SAPPassport.updatePacket(connectionCounter, this._packet, this._passportOffset);
        this._passportConnectionCounter = connectionCounter;
        return true;
    }

    public void close() {
        this._closePacket();
    }

    protected void _resize(int requiredSize) {
        int alignedSize = PacketAnalyzer.align(requiredSize);
        byte[] packet = new byte[alignedSize];
        System.arraycopy(this._packet, 0, packet, 0, this._packetLength);
        this._packet = packet;
        ++_resizeCount;
    }

    protected void _closePart(int argumentCount, int partLength) {
        this._packetLength += partLength;
        this._argumentCount = argumentCount;
        this._closePart();
    }

    private void _initPacket() {
        this._segments.clear();
        this._messageType = null;
        this._packetLength = 32;
        this._segmentCount = 0;
        this._segmentIndex = -1;
        this._segmentOffset = -1;
        this._partCount = (short)-1;
        this._partIndex = -1;
        this._partOffset = -1;
        this._argumentCount = -1;
        this._sendTimeOffset = -1;
        this._receiveTimeOffset = -1;
        this._passportOffset = -1;
        this._passport = null;
        this._passportConnectionCounter = -1;
        this._hasConnectionLevelClientRoutingInfoForStatementRouting = false;
        this._hasConnectionLevelClientRoutingInfoForHintRouting = false;
        ByteUtils.putByte(0, this._packet, 22);
    }

    private void _newSegment(MessageType messageType, ConnectionSapDB connection, Session session) {
        this._newSegment(messageType, connection, session, 2, 0, null, EnumSet.noneOf(SegmentFlags.class));
    }

    private void _newSegment(MessageType messageType, ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, ParseID parseID, EnumSet<SegmentFlags> segmentFlags) {
        int commandOptions;
        int commitImmediately;
        boolean isFirstSegment = !segmentFlags.contains((Object)SegmentFlags.IS_ADDITIONAL_SEGMENT);
        boolean ensureMinimumSpaceRemaining = !segmentFlags.contains((Object)SegmentFlags.NO_MINIMUM_SPACE_REMAINING_REQUIRED);
        boolean fullCompileOnPrepare = segmentFlags.contains((Object)SegmentFlags.FULL_COMPILE_ON_PREPARE);
        this._closeSegment();
        this._segmentIndex = this._segmentCount;
        this._segmentCount = (short)(this._segmentCount + 1);
        this._segmentOffset = this._packetLength;
        this._partCount = 0;
        this._partIndex = -1;
        this._partOffset = -1;
        this._argumentCount = -1;
        this._packetLength += 24;
        this._segments.add(new Segment(this._segmentOffset));
        if (isFirstSegment) {
            this._messageType = messageType;
        }
        switch (messageType) {
            case Prepare: {
                commitImmediately = connection.isAutoCommit() && connection.getBooleanConnectionProperty(ConnectionProperty.RESPECT_AUTO_COMMIT_ON_PREPARE) ? 1 : 0;
                break;
            }
            case ExecuteDirect: 
            case Execute: 
            case PrepareAndExecute: 
            case ReadLOB: 
            case FetchNext: {
                commitImmediately = connection.isAutoCommit() ? 1 : 0;
                break;
            }
            default: {
                commitImmediately = 0;
            }
        }
        switch (resultSetHoldability) {
            case 1: {
                commandOptions = CommandOption.HOLD_CURSORS_OVER_COMMIT.getValue();
                break;
            }
            case 2: {
                commandOptions = 0;
                break;
            }
            case 1000001: {
                commandOptions = CommandOption.HOLD_CURSORS_OVER_ROLLBACK.getValue();
                break;
            }
            case 1000002: {
                commandOptions = CommandOption.HOLD_CURSORS_OVER_COMMIT.getValue() | CommandOption.HOLD_CURSORS_OVER_ROLLBACK.getValue();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected result set holdability: " + resultSetHoldability));
            }
        }
        ByteUtils.putInt(this._segmentOffset - 32, this._packet, this._segmentOffset + 4);
        ByteUtils.putShort(this._segmentIndex + 1, this._packet, this._segmentOffset + 10);
        ByteUtils.putByte(SegmentKind.Cmd.getValue(), this._packet, this._segmentOffset + 12);
        ByteUtils.putByte(messageType.getValue(), this._packet, this._segmentOffset + 13);
        ByteUtils.putByte(commitImmediately, this._packet, this._segmentOffset + 14);
        ByteUtils.putByte(commandOptions, this._packet, this._segmentOffset + 15);
        switch (messageType) {
            case Authenticate: 
            case Connect: 
            case Disconnect: 
            case DBConnectInfo: 
            case Ping: {
                break;
            }
            default: {
                this._addStatementContextPart(connection, queryTimeout, fullCompileOnPrepare);
                if (!isFirstSegment) break;
                this._addProfilePart(connection);
            }
        }
        if (isFirstSegment && connection != null && session != null) {
            if (session.isSendSessionContextFlagSet() && !session.isWebSocketConnection()) {
                this._addSessionContextPart(connection);
                session.clearSendSessionContextFlag();
            }
            this._addClientInfoAndDropStatementIDParts(connection, session, parseID, ensureMinimumSpaceRemaining);
        }
    }

    private void _newPart(PartKind partKind) {
        this._closePart();
        this._partIndex = this._partCount;
        this._partCount = (short)(this._partCount + 1);
        this._partOffset = this._packetLength;
        this._argumentCount = 0;
        this._packetLength += 16;
        this._segments.get(this._segmentIndex)._parts.add(new Part(this._partOffset));
        ByteUtils.putByte(partKind.getValue(), this._packet, this._partOffset + 0);
        ByteUtils.putByte(0, this._packet, this._partOffset + 1);
    }

    private void _closePart() {
        if (this._partIndex == -1) {
            return;
        }
        int partLength = this._packetLength - this._partOffset - 16;
        PacketAnalyzer.putArgumentCount(this._argumentCount, this._packet, this._partOffset);
        ByteUtils.putInt(partLength, this._packet, this._partOffset + 8);
        ((Part)this._segments.get(this._segmentIndex)._parts.get(this._partIndex))._length = partLength;
        this._packetLength = PacketAnalyzer.align(this._packetLength);
        this._partIndex = -1;
        this._partOffset = -1;
        this._argumentCount = -1;
    }

    private void _closeSegment() {
        if (this._segmentIndex == -1) {
            return;
        }
        this._closePart();
        int segmentLength = this._packetLength - this._segmentOffset;
        ByteUtils.putInt(segmentLength, this._packet, this._segmentOffset + 0);
        ByteUtils.putShort(this._partCount, this._packet, this._segmentOffset + 8);
        this._segments.get(this._segmentIndex)._length = segmentLength;
        this._segmentIndex = -1;
        this._segmentOffset = -1;
        this._partCount = (short)-1;
    }

    private void _closePacket() {
        this._closeSegment();
        for (Segment segment : this._segments) {
            for (Part part : segment._parts) {
                ByteUtils.putInt(this._packetLength - part._offset - 16 - part._length, this._packet, part._offset + 12);
            }
        }
        ByteUtils.putInt(this._packetLength - 32, this._packet, 12);
        ByteUtils.putInt(this._packetLength - 32, this._packet, 16);
        ByteUtils.putShort(this._segmentCount, this._packet, 20);
    }

    private HOptionsPart _addOptionsPart(PartKind partKind) {
        this._newPart(partKind);
        return new HOptionsPart(this, this._packetLength);
    }

    private HMultiLineOptionsPart _addMultiLineOptionsPart(PartKind partKind) {
        this._newPart(partKind);
        return new HMultiLineOptionsPart(this, this._packetLength);
    }

    private void _addStatementContextPart(ConnectionSapDB connection, int queryTimeout, boolean fullCompileOnPrepare) {
        boolean includeQueryTimeout;
        byte[] statementContext = connection.getStatementContext();
        boolean includeStatementSequenceInfo = statementContext != null;
        boolean bl = includeQueryTimeout = connection.getEngineFeatures().isQueryTimeoutSupported() && queryTimeout > 0;
        if (!(includeStatementSequenceInfo || includeQueryTimeout || fullCompileOnPrepare)) {
            return;
        }
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.StatementContext);
        if (includeStatementSequenceInfo) {
            optionsPart.addBinaryOption(StatementContextOption.StatementSequenceInfo.getValue(), statementContext);
            this._segments.get(this._segmentIndex)._statementContextOffset = this._packetLength + 4;
        }
        if (includeQueryTimeout) {
            optionsPart.addLongOption(StatementContextOption.QueryTimeout.getValue(), queryTimeout);
        }
        if (fullCompileOnPrepare) {
            optionsPart.addTinyIntOption(StatementContextOption.FlagSet.getValue(), StatementContextFlag.FullCompileOnPrepare.getValue());
        }
        optionsPart.close();
    }

    private void _addProfilePart(ConnectionSapDB connection) {
        if (this._sendTimeOffset != -1 || !connection.getEngineFeatures().ignoresUnknownParts()) {
            return;
        }
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.Profile);
        optionsPart.addLongOption(ProfileElement.SendTime.getValue(), -1L);
        this._sendTimeOffset = this._packetLength + 2;
        optionsPart.addLongOption(ProfileElement.ReceiveTime.getValue(), -1L);
        this._receiveTimeOffset = this._packetLength + 12;
        optionsPart.close();
    }

    private void _addSessionContextPart(ConnectionSapDB connection) {
        int anchorPortNumber;
        String anchorHostName;
        int anchorConnectionID;
        int primaryPortNumber;
        String primaryHostName;
        int primaryConnectionID;
        Address address;
        SessionPool sessionPool = connection.getSessionPool();
        Session primarySession = sessionPool.getPrimarySession();
        Session anchorSession = sessionPool.getAnchorSession();
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.SessionContext);
        if (primarySession != null) {
            address = primarySession.getAddress();
            primaryConnectionID = primarySession.getConnectionID();
            primaryHostName = address.getHost();
            primaryPortNumber = address.getPort();
        } else {
            primaryConnectionID = 0;
            primaryHostName = UNKNOWN_HOST_NAME;
            primaryPortNumber = 0;
        }
        if (anchorSession != null) {
            address = anchorSession.getAddress();
            anchorConnectionID = anchorSession.getConnectionID();
            anchorHostName = address.getHost();
            anchorPortNumber = address.getPort();
        } else {
            anchorConnectionID = 0;
            anchorHostName = UNKNOWN_HOST_NAME;
            anchorPortNumber = 0;
        }
        optionsPart.addIntOption(SessionContextOption.PrimaryConnectionID.getValue(), primaryConnectionID);
        optionsPart.addStringOption(SessionContextOption.PrimaryHostName.getValue(), primaryHostName);
        optionsPart.addIntOption(SessionContextOption.PrimaryHostPortNumber.getValue(), primaryPortNumber);
        optionsPart.addIntOption(SessionContextOption.AnchorConnectionID.getValue(), anchorConnectionID);
        optionsPart.addStringOption(SessionContextOption.AnchorHostName.getValue(), anchorHostName);
        optionsPart.addIntOption(SessionContextOption.AnchorHostPortNumber.getValue(), anchorPortNumber);
        optionsPart.close();
    }

    private void _addClientInfoAndDropStatementIDParts(ConnectionSapDB connection, Session session, ParseID parseID, boolean ensureMinimumSpaceRemaining) {
        int availableSpace;
        boolean addDropStatementIDPart;
        SAPPassport passport = connection.getPassport();
        Map<String, String> transform = null;
        boolean addClientInfoPart = (session.isSendSessionVariablesFlagSet() || session.isSendClientInfoFlagSet()) && (transform = connection.generateClientInfoTransform(session)) != null || passport != null;
        List<ParseID> dequeuedForDrop = connection.dequeueForLazyDrop(session, parseID);
        boolean bl = addDropStatementIDPart = dequeuedForDrop != null;
        if (!addClientInfoPart && !addDropStatementIDPart) {
            return;
        }
        int requiredSpace = 0;
        if (addClientInfoPart) {
            requiredSpace += 16;
            if (transform != null) {
                for (Map.Entry<String, String> entry : transform.entrySet()) {
                    if (passport != null && entry.getKey().equals("SAP_PASSPORT")) continue;
                    requiredSpace += this._getVariableStringArgLength(entry.getKey());
                    requiredSpace += this._getVariableStringArgLength(entry.getValue());
                }
            }
            if (passport != null) {
                requiredSpace += this._getVariableStringArgLength("SAP_PASSPORT");
                requiredSpace += this._getVariableStringArgLength(passport.getOutboundHexString());
            }
            requiredSpace = PacketAnalyzer.align(requiredSpace);
        }
        if (addDropStatementIDPart) {
            requiredSpace += PacketAnalyzer.align(16 + dequeuedForDrop.size() * 8);
        }
        if (ensureMinimumSpaceRemaining) {
            requiredSpace += 4096;
        }
        if (requiredSpace > (availableSpace = this.getAvailableSpace())) {
            this._resize(this._packetLength + requiredSpace);
        }
        if (addClientInfoPart) {
            this._addClientInfoPart(transform, passport);
            session.clearSendSessionVariablesAndClientInfoFlags(connection);
        }
        if (addDropStatementIDPart) {
            this._addDropStatementIDPart(dequeuedForDrop);
        }
    }

    private void _addClientInfoPart(Map<String, String> transform, SAPPassport passport) {
        this._newPart(PartKind.ClientInfo);
        if (transform != null) {
            for (Map.Entry<String, String> entry : transform.entrySet()) {
                if (passport != null && entry.getKey().equals("SAP_PASSPORT")) continue;
                this._addVariableStringArg(entry.getKey());
                this._addVariableStringArg(entry.getValue());
            }
        }
        if (passport != null) {
            this._addVariableStringArg("SAP_PASSPORT");
            int packetLength = this._packetLength;
            this._passport = passport;
            int passportLengthIndicatorLength = this._addVariableStringArg(passport.getOutboundHexString());
            this._passportOffset = packetLength + passportLengthIndicatorLength;
        }
        this._closePart();
    }

    private void _addDropStatementIDPart(List<ParseID> dequeuedForDrop) {
        this._newPart(PartKind.DropStatementID);
        for (ParseID parseID : dequeuedForDrop) {
            this._addBytesArg(parseID.getParseID());
        }
        this._closePart();
    }

    private void _addClientContextPart(ConnectionSapDB connection) {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.ClientContext);
        String application = connection.getConnectionProperty(ConnectionProperty.APPLICATION);
        optionsPart.addStringOption(ClientContextOption.ClientVersion.getValue(), Driver.getVersionInfo().toShortVersionNumberString());
        optionsPart.addStringOption(ClientContextOption.ClientType.getValue(), "JDBC");
        optionsPart.addStringOption(ClientContextOption.ClientApplicationProgram.getValue(), application != null && !application.isEmpty() ? application : "UNKNOWN");
        optionsPart.close();
    }

    private void _addClientIDPart(String clientID) {
        this._newPart(PartKind.ClientID);
        this._addDataStringArg(clientID);
        this._closePart();
    }

    private void _addConnectOptionsPart(ConnectionSapDB connection, Session session, Session anchorSession) {
        String osUser;
        ConnectionProperties connectionProperties = connection.getConnectionProperties();
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.ConnectOptions);
        optionsPart.addStringOption(ConnectOption.FullVersionString.getValue(), Driver.getVersionInfo().toShortVersionNumberString());
        String databaseName = connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
        if (databaseName != null && !databaseName.isEmpty()) {
            optionsPart.addStringOption(ConnectOption.DatabaseName.getValue(), databaseName);
        }
        optionsPart.addIntOption(ConnectOption.BuildPlatform.getValue(), BuildPlatform.Java.getValue());
        String locale = connectionProperties.getProperty(ConnectionProperty.LOCALE);
        if (locale != null && !locale.isEmpty()) {
            optionsPart.addStringOption(ConnectOption.ClientLocale.getValue(), locale);
        }
        int newerFormatVersion = DataFormatVersion.Level1.getValue();
        String requestedDataFormat = connectionProperties.getProperty(ConnectionProperty.DATA_FORMAT_SUPPORT);
        try {
            int dataFormatVersion = Integer.parseInt(requestedDataFormat);
            if (dataFormatVersion >= DataFormatVersion.Level4.getValue() && dataFormatVersion <= DataFormatVersion.Level8.getValue()) {
                newerFormatVersion = dataFormatVersion;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        optionsPart.addIntOption(ConnectOption.DataFormatVersion.getValue(), DataFormatVersion.Level1.getValue());
        optionsPart.addIntOption(ConnectOption.DataFormatVersion2.getValue(), newerFormatVersion);
        String connectionID = connectionProperties.getProperty(ConnectionProperty.ASSOCIATED_CONNECTION_ID);
        if (connectionID != null && !connectionID.isEmpty()) {
            try {
                optionsPart.addIntOption(ConnectOption.AssociatedConnectionID.getValue(), Integer.parseInt(connectionID));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((osUser = connectionProperties.getProperty(ConnectionProperty.APPLICATIONUSER)) != null && !osUser.isEmpty()) {
            optionsPart.addStringOption(ConnectOption.OSUser.getValue(), osUser);
        }
        if (!connectionProperties.getBooleanProperty(ConnectionProperty.IGNORE_TOPOLOGY)) {
            int distributionMode = connection.getDistributionMode().getValue();
            if (distributionMode > DistributionMode.Off.getValue()) {
                optionsPart.addBooleanOption(ConnectOption.DistributionEnabled.getValue(), true);
            }
            optionsPart.addIntOption(ConnectOption.ClientDistributionMode.getValue(), distributionMode);
            optionsPart.addIntOption(ConnectOption.DistributionProtocolVersion.getValue(), DistributionProtocolVersion.MultiLevelPartitionSupported.getValue());
        }
        optionsPart.addIntOption(ConnectOption.ActiveActiveProtocolVersion.getValue(), connectionProperties.getIntProperty(ConnectionProperty.SYSTEM_REPLICATION_PROTOCOL_VERSION));
        SiteType siteType = anchorSession != null && anchorSession.getAddress() instanceof PublicAddress ? ((PublicAddress)anchorSession.getAddress()).getSiteType() : SiteType.NONE;
        optionsPart.addIntOption(ConnectOption.ActiveActiveConnectionOriginSite.getValue(), siteType.getValue());
        optionsPart.addIntOption(ConnectOption.ClientSideColumnEncryptionVersion.getValue(), connectionProperties.getIntProperty(ConnectionProperty.CLIENT_SIDE_ENCRYPTION_VERSION));
        boolean addCompressionFlags = true;
        int compressionFlags = 256;
        if (connectionProperties.hasProperty(ConnectionProperty.COMPRESS)) {
            if (connectionProperties.getBooleanProperty(ConnectionProperty.COMPRESS)) {
                compressionFlags |= 0x200;
            } else {
                addCompressionFlags = false;
            }
        }
        if (connectionProperties.getBooleanProperty(ConnectionProperty.ALLOW_LOCAL_COMPRESS)) {
            compressionFlags |= 0x400;
        }
        if (addCompressionFlags) {
            optionsPart.addIntOption(ConnectOption.CompressionLevelAndFlags.getValue(), compressionFlags);
        }
        if (connection != null) {
            int anchorConnectionID;
            int serverReconnectWaitTimeout;
            EngineFeatures engineFeatures = connection.getEngineFeatures();
            if (engineFeatures != null && (serverReconnectWaitTimeout = engineFeatures.getReconnectWaitTimeout()) != -1) {
                optionsPart.addIntOption(ConnectOption.ClientReconnectWaitTimeout.getValue(), serverReconnectWaitTimeout);
            }
            if ((anchorConnectionID = connection.getSessionPool().getLastAnchorConnectionID()) != -1) {
                optionsPart.addIntOption(ConnectOption.OriginalAnchorConnectionID.getValue(), anchorConnectionID);
            }
        }
        if (connection.refCursors() || connectionProperties.getBooleanProperty(ConnectionProperty.TABLE_OUTPUT_PARAMETER_META_DATA)) {
            optionsPart.addBooleanOption(ConnectOption.DescribeTableOutputParameter.getValue(), true);
            optionsPart.addBooleanOption(ConnectOption.TableOutputParameterMetadataSupport.getValue(), true);
        }
        int flagSet1 = 0;
        if (connectionProperties.getBooleanProperty(ConnectionProperty._FEATURE_HEARTBEAT)) {
            int lrrPingTime;
            boolean heartbeatFromServer;
            boolean heartbeatFromClient;
            String heartbeatSender = connectionProperties.getProperty(ConnectionProperty.HEARTBEAT_SENDER);
            if (heartbeatSender.equalsIgnoreCase("CLIENT")) {
                heartbeatFromClient = true;
                heartbeatFromServer = false;
            } else if (heartbeatSender.equalsIgnoreCase("SERVER")) {
                heartbeatFromClient = false;
                heartbeatFromServer = true;
            } else {
                heartbeatFromClient = true;
                heartbeatFromServer = true;
            }
            if (connectionProperties.hasProperty(ConnectionProperty.HEARTBEAT_TIME)) {
                int heartbeatTime = connectionProperties.getIntProperty(ConnectionProperty.HEARTBEAT_TIME);
                if (heartbeatTime == 0) {
                    heartbeatFromClient = false;
                    heartbeatFromServer = false;
                    lrrPingTime = -1;
                } else {
                    lrrPingTime = heartbeatTime;
                }
            } else {
                lrrPingTime = 0;
            }
            if (!connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL).isEmpty() || !connectionProperties.getBooleanProperty(ConnectionProperty.NON_BLOCKING_IO)) {
                heartbeatFromClient = false;
            }
            if (!connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL).isEmpty()) {
                heartbeatFromServer = false;
            }
            if (heartbeatFromClient) {
                flagSet1 |= ConnectOptionFlagSet1.SupportIdlePing.getValue();
                flagSet1 |= ConnectOptionFlagSet1.SupportIdlePingDuringRequest.getValue();
            }
            if (heartbeatFromServer) {
                optionsPart.addIntOption(ConnectOption.LRRPingTime.getValue(), lrrPingTime);
            }
        }
        flagSet1 |= ConnectOptionFlagSet1.HoldCursorOverRollbackSupported.getValue();
        if (connectionProperties.getIntProperty(ConnectionProperty.MAX_LAZY_DROPPED_STATEMENTS) > 0) {
            flagSet1 |= ConnectOptionFlagSet1.SupportDropStatementIDPart.getValue();
        }
        flagSet1 |= ConnectOptionFlagSet1.SupportFullCompileOnPrepare.getValue();
        flagSet1 |= ConnectOptionFlagSet1.Support32BitFetchSize.getValue();
        flagSet1 |= ConnectOptionFlagSet1.SupportSessionContextOnSecondary.getValue();
        flagSet1 |= ConnectOptionFlagSet1.SupportSavepointSQL.getValue();
        flagSet1 |= ConnectOptionFlagSet1.SupportDeferredPrepare.getValue();
        flagSet1 |= ConnectOptionFlagSet1.SupportImplicitXAJoinOnPrepare.getValue();
        flagSet1 |= ConnectOptionFlagSet1.SupportSessionContextPartOnConnect.getValue();
        if (connectionProperties.getBooleanProperty(ConnectionProperty.LOB_LOCATOR_0_FULL_VALUE)) {
            flagSet1 |= ConnectOptionFlagSet1.LobLocator0FullValueOK.getValue();
        }
        if (connectionProperties.getBooleanProperty(ConnectionProperty._FEATURE_CLIENT_ROUTING_INFO)) {
            flagSet1 |= ConnectOptionFlagSet1.SupportClientRoutingInfo.getValue();
            if (connectionProperties.getBooleanProperty(ConnectionProperty.IGNORE_TOPOLOGY)) {
                flagSet1 |= ConnectOptionFlagSet1.DisabledClientRouting_IgnoreTopology.getValue();
            }
        }
        if (connectionProperties.getBooleanProperty(ConnectionProperty.FORCE_REROUTE)) {
            flagSet1 |= ConnectOptionFlagSet1.SupportForceReroute.getValue();
        }
        if (connectionProperties.getBooleanProperty(ConnectionProperty.FORCE_REROUTE_ON_PREPARE)) {
            flagSet1 |= ConnectOptionFlagSet1.SupportForceRerouteOnPrepare.getValue();
        }
        if (connectionProperties.getBooleanProperty(ConnectionProperty._FEATURE_SESSION_COOKIE_FOR_ALL_METHODS)) {
            flagSet1 |= ConnectOptionFlagSet1.SupportSessionCookieForAllMethods.getValue();
        }
        optionsPart.addIntOption(ConnectOption.FlagSet1.getValue(), flagSet1);
        optionsPart.addBooleanOption(ConnectOption.ImplicitXASessionSupported.getValue(), true);
        String networkGroup = connectionProperties.getProperty(ConnectionProperty.NETWORK_GROUP);
        if (networkGroup != null && !networkGroup.isEmpty()) {
            optionsPart.addStringOption(ConnectOption.TopologyNetworkGroup.getValue(), networkGroup.toLowerCase(Locale.ENGLISH));
        }
        optionsPart.addStringOption(ConnectOption.IPAddress.getValue(), session.getLocalAddress().getHost());
        optionsPart.addBooleanOption(ConnectOption.CompleteArrayExecution.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.LargeNumberOfParametersSupport.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.SelectForUpdateSupported.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.EnableArrayType.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.XOpenXAProtocolSupported.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.QueryTimeoutSupported.getValue(), true);
        optionsPart.addIntOption(ConnectOption.RedirectionType.getValue(), connection.getRedirectionType().getValue());
        String redirectedHost = connection.getRedirectedHost();
        int redirectedPort = connection.getRedirectedPort();
        if (redirectedHost != null && !redirectedHost.isEmpty() && redirectedPort > 0) {
            optionsPart.addStringOption(ConnectOption.RedirectedHost.getValue(), redirectedHost);
            optionsPart.addIntOption(ConnectOption.RedirectedPort.getValue(), redirectedPort);
        }
        optionsPart.addStringOption(ConnectOption.EndPointHost.getValue(), connection.getEndPointHost());
        optionsPart.addIntOption(ConnectOption.EndPointPort.getValue(), connection.getEndPointPort());
        optionsPart.addStringOption(ConnectOption.EndPointList.getValue(), connection.getEndPointList());
        optionsPart.close();
    }

    private void _addDBConnectInfoPart(String databaseName, String networkGroup) {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.DBConnectInfo);
        if (databaseName != null && !databaseName.isEmpty()) {
            optionsPart.addStringOption(DBConnectInfoOption.DatabaseName.getValue(), databaseName);
        }
        if (networkGroup != null && !networkGroup.isEmpty()) {
            optionsPart.addStringOption(DBConnectInfoOption.TopologyNetworkGroup.getValue(), networkGroup);
        }
        optionsPart.close();
    }

    private void _addCommandPart(String sql) {
        this._newPart(PartKind.Command);
        this._addStringArg(sql);
        this._closePart();
    }

    private void _addCommandInfoPart(String commandInfoSource, int commandInfoLine) {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.CommandInfo);
        optionsPart.addIntOption(CommandInfo.LineNumber.getValue(), commandInfoLine);
        optionsPart.addStringOption(CommandInfo.SourceModule.getValue(), commandInfoSource);
        optionsPart.close();
        ++_commandInfoPartCount;
    }

    private int _getRequiredSpaceForClientRoutingInfos(List<ClientRoutingInfo> clientRoutingInfos) {
        int requiredSpace = 16;
        for (ClientRoutingInfo clientRoutingInfo : clientRoutingInfos) {
            requiredSpace += Cesu8Utils.getByteLength(clientRoutingInfo.getDescription()) + 15;
        }
        requiredSpace = PacketAnalyzer.align(requiredSpace);
        return requiredSpace;
    }

    private void _addClientRoutingInfoPart(List<ClientRoutingInfo> clientRoutingInfos) {
        HMultiLineOptionsPart multiLineOptionsPart = this._addMultiLineOptionsPart(PartKind.ClientRoutingInfo);
        for (ClientRoutingInfo clientRoutingInfo : clientRoutingInfos) {
            multiLineOptionsPart.addLine(3);
            ClientRoutingInfoDescriptionType descriptionType = clientRoutingInfo.getDescriptionType();
            String description = clientRoutingInfo.getDescription();
            ClientRoutingInfo.ConnectionLevelDecision connectionLevelDecision = clientRoutingInfo.getDecisionLevel();
            if (connectionLevelDecision == ClientRoutingInfo.ConnectionLevelDecision.CONNECTION) {
                switch (descriptionType) {
                    case AAFallbackReason: {
                        this._hasConnectionLevelClientRoutingInfoForHintRouting = true;
                        break;
                    }
                    case RoutingWarning: {
                        this._hasConnectionLevelClientRoutingInfoForStatementRouting = true;
                        break;
                    }
                    case All: {
                        this._hasConnectionLevelClientRoutingInfoForHintRouting = true;
                        this._hasConnectionLevelClientRoutingInfoForStatementRouting = true;
                        break;
                    }
                }
            }
            multiLineOptionsPart.addIntOption(ClientRoutingInfoType.DescriptionType.getValue(), descriptionType.getValue());
            multiLineOptionsPart.addStringOption(ClientRoutingInfoType.Description.getValue(), description);
            multiLineOptionsPart.addBooleanOption(ClientRoutingInfoType.ConnectionLevelDecision.getValue(), connectionLevelDecision.getValue());
        }
        multiLineOptionsPart.close();
    }

    private void _addReadLOBRequestPart(byte[] locatorID, long position, int packetSize) {
        int lobReadChunkSize = Math.max(packetSize, 200000);
        this._newPart(PartKind.ReadLOBRequest);
        ByteUtils.putBytes(locatorID, this._packet, this._packetLength + 0);
        ByteUtils.putLong(position, this._packet, this._packetLength + 8);
        ByteUtils.putInt(lobReadChunkSize, this._packet, this._packetLength + 16);
        ByteUtils.putInt(0, this._packet, this._packetLength + 20);
        this._packetLength += 24;
        ++this._argumentCount;
        this._closePart();
    }

    private void _addResultSetIDPart(CursorID cursorID) {
        this._newPart(PartKind.ResultSetID);
        this._addBytesArg(cursorID.getCursorID());
        this._closePart();
    }

    private void _addFetchSizePart(int fetchSize) {
        this._newPart(PartKind.FetchSize);
        this._addIntArg(fetchSize);
        this._closePart();
    }

    private void _addStatementIDPart(ParseID parseID) {
        this._newPart(PartKind.StatementID);
        this._addBytesArg(parseID.getParseID());
        this._closePart();
    }

    private void _addCommitOptionsPart() {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.CommitOptions);
        optionsPart.addBooleanOption(CommitOption.HoldCursorOverCommit.getValue(), true);
        optionsPart.close();
    }

    private void _addTransactionIDPart(byte[] transactionID) {
        this._newPart(PartKind.TransactionID);
        this._addBytesArg(transactionID);
        this._closePart();
    }

    private void _addXATransactionInfoPart(Xid xid, Integer flags, Boolean onePhase) {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.XOpen_XATransactionInfo);
        if (xid != null) {
            optionsPart.addLongOption(XATransactionInfoOption.NumberOfXID.getValue(), 1L);
            optionsPart.addBinaryOption(XATransactionInfoOption.XIDList.getValue(), XidSAP.getBytes(xid));
        }
        if (flags != null) {
            optionsPart.addIntOption(XATransactionInfoOption.Flags.getValue(), flags);
        }
        if (onePhase != null) {
            optionsPart.addBooleanOption(XATransactionInfoOption.OnePhase.getValue(), onePhase);
        }
        optionsPart.close();
    }

    private void _addIntArg(int value) {
        ByteUtils.putInt(value, this._packet, this._packetLength);
        this._packetLength += 4;
        ++this._argumentCount;
    }

    private void _addStringArg(String value) {
        this._packetLength += Cesu8Utils.putBytes(value, this._packet, this._packetLength);
        ++this._argumentCount;
    }

    private void _addDataStringArg(String value) {
        ByteUtils.putByte(32, this._packet, this._packetLength);
        ++this._packetLength;
        this._addStringArg(value);
    }

    private int _getVariableStringArgLength(String value) {
        if (value == null) {
            return 1;
        }
        int length = Cesu8Utils.getByteLength(value);
        if (length <= 245) {
            return length + 1;
        }
        if (length <= Short.MAX_VALUE) {
            return length + 3;
        }
        return length + 5;
    }

    private int _addVariableStringArg(String value) {
        int lengthIndicatorLength;
        int dataOffset = this._packetLength;
        if (value == null) {
            ByteUtils.putByte(255, this._packet, dataOffset);
            lengthIndicatorLength = 1;
            this._packetLength += lengthIndicatorLength;
        } else {
            int length = Cesu8Utils.getByteLength(value);
            if (length <= 245) {
                ByteUtils.putByte(length, this._packet, dataOffset);
                lengthIndicatorLength = 1;
            } else if (length <= Short.MAX_VALUE) {
                ByteUtils.putByte(246, this._packet, dataOffset);
                ByteUtils.putShort(length, this._packet, dataOffset + 1);
                lengthIndicatorLength = 3;
            } else {
                ByteUtils.putByte(247, this._packet, dataOffset);
                ByteUtils.putInt(length, this._packet, dataOffset + 1);
                lengthIndicatorLength = 5;
            }
            this._packetLength += lengthIndicatorLength;
            this._packetLength += Cesu8Utils.putBytes(value, this._packet, this._packetLength);
        }
        ++this._argumentCount;
        return lengthIndicatorLength;
    }

    private void _addBytesArg(byte[] value) {
        ByteUtils.putBytes(value, this._packet, this._packetLength);
        this._packetLength += value.length;
        ++this._argumentCount;
    }

    public static int getResizeCount() {
        return _resizeCount;
    }

    public static void clearResizeCount() {
        _resizeCount = 0;
    }

    public static int getCommandInfoPartCount() {
        return _commandInfoPartCount;
    }

    public static void resetCommandInfoPartCount() {
        _commandInfoPartCount = 0;
    }

    private static class Part {
        private final int _offset;
        private int _length;

        private Part(int offset) {
            this._offset = offset;
        }

        public String toString() {
            return this._offset + ":" + this._length;
        }
    }

    private static class Segment {
        private final int _offset;
        private final List<Part> _parts;
        private int _statementContextOffset;
        private int _length;

        private Segment(int offset) {
            this._offset = offset;
            this._parts = new ArrayList<Part>();
            this._statementContextOffset = -1;
        }

        public String toString() {
            return this._offset + ":" + this._length + "(" + this._parts.size() + ")";
        }
    }

    private static enum SegmentFlags {
        IS_ADDITIONAL_SEGMENT,
        NO_MINIMUM_SPACE_REMAINING_REQUIRED,
        FULL_COMPILE_ON_PREPARE;

    }
}

