/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.HexUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class IntConverter
extends AbstractNumericConverter {
    private static final Integer MIN_VALUE = Integer.MIN_VALUE;
    private static final Integer MAX_VALUE = Integer.MAX_VALUE;
    private static final BigDecimal MIN_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MIN_VALUE.intValue());
    private static final BigDecimal MAX_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MAX_VALUE.intValue());

    protected IntConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? 4 : 5) + 1;
        }
        return 5;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? 4 : 5) + 2;
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        int value = (Integer)data;
        if (this._isEncrypted) {
            int off;
            byte[] bytes;
            if (this._isDeterministic) {
                bytes = new byte[4];
                off = 0;
            } else {
                bytes = new byte[5];
                ByteUtils.putByte(1, bytes, 0);
                off = 1;
            }
            ByteUtils.putInt(value, bytes, off);
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putIntAsInt(value);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Integer.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : Integer.valueOf(this._getValueAsInt(controller, dataPart, false, decrypted, null));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true, null, outIsNull) != 0;
    }

    @Override
    public Integer setBoolean(boolean value) throws SQLException {
        return value ? 1 : 0;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (byte)this._getValueAsInt(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Integer setByte(byte value) throws SQLException {
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (short)this._getValueAsInt(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Integer setShort(short value) throws SQLException {
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Integer setInt(int value) throws SQLException {
        return value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Integer setLong(long value) throws SQLException {
        if (value < (long)MIN_VALUE.intValue() || value > (long)MAX_VALUE.intValue()) {
            throw IntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (int)value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Integer setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw IntConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (float)MIN_VALUE.intValue() || value > (float)MAX_VALUE.intValue()) {
            throw IntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (int)value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Integer setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw IntConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (double)MIN_VALUE.intValue() || value > (double)MAX_VALUE.intValue()) {
            throw IntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (int)value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : BigDecimal.valueOf(this._getValueAsInt(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Integer setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.compareTo(MIN_VALUE_BIG_DECIMAL) < 0 || value.compareTo(MAX_VALUE_BIG_DECIMAL) > 0) {
            throw IntConverter._newSetNumericValueOutOfRangeException(value.toPlainString(), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value.intValue();
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : String.valueOf(this._getValueAsInt(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Integer setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw IntConverter._newSetConversionException(value, "int");
        }
    }

    @Override
    public Integer setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(HexUtils.toDisplayHexString(value));
        }
        return value[0] & 0xFF;
    }

    private int _getValueAsInt(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted, boolean[] outIsNull) throws SQLException {
        if (doNullCheck) {
            decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            boolean isNull = dataPart.isNull(this, controller, decrypted);
            if (outIsNull != null) {
                outIsNull[0] = isNull;
            }
            if (isNull) {
                return 0;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getInt(decrypted, this._isDeterministic ? 0 : 1);
        }
        return dataPart.getIntAsInt();
    }
}

