/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaPreparedStatement;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.SQLException;

@ThreadSafe
public class HanaPreparedStatementFinalize
extends HanaPreparedStatement {
    protected static HanaPreparedStatement newInstance(Tracer tracer, ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementSapDB.StatementFlag ... statementFlags) throws SQLException {
        HanaPreparedStatementFinalize statement = new HanaPreparedStatementFinalize(tracer, connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
        connection._addStatement(statement);
        return statement;
    }

    protected HanaPreparedStatementFinalize(Tracer tracer, ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementSapDB.StatementFlag ... statementFlags) throws SQLException {
        super(tracer, connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    protected void finalize() throws Throwable {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        try {
            if (on) {
                this._tracer.printFinalizing(this.getTraceString(true));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._clean();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
        }
        finally {
            super.finalize();
            if (on) {
                this._tracer.printFinalized();
            }
        }
    }
}

