/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.google.common.annotations.Beta;
import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.Result;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class ResultBuilder {
    private static ResultBuilder builder() {
        return Cds4jServiceLoader.load(ResultBuilder.class);
    }

    private static ResultBuilder builder(List<? extends Map<String, ?>> rows) {
        return ResultBuilder.builder().rows(rows);
    }

    public static ResultBuilder selectedRows(List<? extends Map<String, ?>> rows) {
        return ResultBuilder.builder(rows).rowCount(new int[]{rows.size()});
    }

    public static ResultBuilder insertedRows(List<? extends Map<String, ?>> rows) {
        int[] rowCount = new int[rows.size()];
        Arrays.fill(rowCount, 1);
        return ResultBuilder.builder(rows).rowCount(rowCount);
    }

    public static ResultBuilder updatedRows(int updateCount, Map<String, ?> updateData) {
        return ResultBuilder.updatedRows((long)updateCount, updateData);
    }

    public static ResultBuilder updatedRows(long updateCount, Map<String, ?> updateData) {
        if (updateCount == 0L) {
            return ResultBuilder.builder();
        }
        return ResultBuilder.builder(Arrays.asList(updateData)).rowCount(new long[]{updateCount});
    }

    public static ResultBuilder updatedRows(int[] updateCount, Map<String, ?> updateData) {
        return ResultBuilder.updatedRows(ResultBuilder.longArray(updateCount), updateData);
    }

    public static ResultBuilder updatedRows(long[] updateCount, Map<String, ?> updateData) {
        if (Arrays.stream(updateCount).anyMatch(c -> c > 0L)) {
            int length = updateCount.length;
            ArrayList rows = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                rows.add(updateCount[i] > 0L ? updateData : new HashMap());
            }
            return ResultBuilder.builder(rows).rowCount(updateCount);
        }
        return ResultBuilder.builder();
    }

    public static ResultBuilder updatedRows(int[] updateCount, List<? extends Map<String, ?>> updateData) {
        return ResultBuilder.updatedRows(ResultBuilder.longArray(updateCount), updateData);
    }

    private static long[] longArray(int[] updateCount) {
        return Arrays.stream(updateCount).asLongStream().toArray();
    }

    public static ResultBuilder updatedRows(long[] updateCount, List<? extends Map<String, ?>> updateData) {
        int size = updateData.size();
        if (size == 1) {
            return ResultBuilder.updatedRows(updateCount, updateData.get(0));
        }
        if (size != updateCount.length) {
            throw new CdsDataException("Update count does not match batch size");
        }
        ArrayList rows = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            rows.add(updateCount[i] > 0L ? updateData.get(i) : new HashMap());
        }
        return ResultBuilder.builder(rows).rowCount(updateCount);
    }

    public static ResultBuilder deletedRows(int deleteCount) {
        return ResultBuilder.deletedRows((long)deleteCount);
    }

    public static ResultBuilder deletedRows(long deleteCount) {
        return ResultBuilder.deletedRows(new long[]{deleteCount});
    }

    public static ResultBuilder deletedRows(int[] deleteCount) {
        return ResultBuilder.builder().rowCount(deleteCount);
    }

    public static ResultBuilder deletedRows(long[] deleteCount) {
        return ResultBuilder.builder().rowCount(deleteCount);
    }

    protected ResultBuilder rows(List<? extends Map<String, ?>> rows) {
        return this.rows(rows.stream());
    }

    protected abstract ResultBuilder rows(Stream<? extends Map<String, ?>> var1);

    protected abstract ResultBuilder rowCount(int[] var1);

    protected abstract ResultBuilder rowCount(long[] var1);

    @Beta
    public abstract ResultBuilder rowType(CdsStructuredType var1);

    public abstract ResultBuilder inlineCount(long var1);

    public abstract Result result();

    public abstract long rowCount();

    public abstract long inlineCount();
}

