/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict.importers;

import com.sandflow.smpte.register.ElementsRegister;
import com.sandflow.smpte.register.GroupsRegister;
import com.sandflow.smpte.register.TypesRegister;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.regxml.dict.definitions.CharacterTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.EnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ExtendibleEnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FixedArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IndirectTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IntegerTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.LensSerialFloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.OpaqueTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyAliasDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RecordTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RenameTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.SetTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StreamTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StringTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StrongReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.VariableArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.WeakReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.exceptions.DuplicateSymbolException;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import com.sandflow.util.events.BasicEvent;
import com.sandflow.util.events.Event;
import com.sandflow.util.events.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RegisterImporter {
    private static final Logger LOGGER = Logger.getLogger(RegisterImporter.class.getName());

    static void handleEvent(EventHandler handler, Event evt) throws Exception {
        if (handler != null ? !handler.handle(evt) || evt.getSeverity() == Event.Severity.FATAL : evt.getSeverity() == Event.Severity.ERROR || evt.getSeverity() == Event.Severity.FATAL) {
            throw new Exception(evt.getMessage());
        }
    }

    public static MetaDictionaryCollection fromRegister(TypesRegister tr, GroupsRegister gr, ElementsRegister er) throws Exception {
        EventHandler handler = new EventHandler(){

            @Override
            public boolean handle(Event evt) {
                switch (evt.getSeverity()) {
                    case ERROR: 
                    case FATAL: {
                        LOGGER.severe(evt.getMessage());
                        break;
                    }
                    case INFO: {
                        LOGGER.info(evt.getMessage());
                        break;
                    }
                    case WARN: {
                        LOGGER.warning(evt.getMessage());
                    }
                }
                return true;
            }
        };
        return RegisterImporter.fromRegister(tr, gr, er, handler);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MetaDictionaryCollection fromRegister(TypesRegister tr, GroupsRegister gr, ElementsRegister er, EventHandler evthandler) throws Exception {
        LinkedHashMap<AUID, ArrayList<Definition>> defs = new LinkedHashMap<AUID, ArrayList<Definition>>();
        HashMap<AUID, HashSet<AUID>> isReferencedBy = new HashMap<AUID, HashSet<AUID>>();
        Iterator<Object> iterator = gr.getEntries().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            GroupsRegister.Entry entry = iterator.next();
            if (entry.getKind().equals((Object)GroupsRegister.Entry.Kind.NODE) || entry.getUL().isClass15() || !entry.getKlvSyntax().contains((byte)83)) continue;
            ClassDefinition cdef = new ClassDefinition();
            if (entry.isConcrete() != null) {
                cdef.setConcrete(entry.isConcrete());
            } else {
                cdef.setConcrete(true);
            }
            cdef.setDescription(entry.getDefinition());
            cdef.setName(entry.getName());
            cdef.setSymbol(entry.getSymbol());
            cdef.setNamespace(entry.getNamespaceName());
            if (entry.getParent() != null) {
                cdef.setParentClass(new AUID(entry.getParent()));
            }
            cdef.setIdentification(new AUID(entry.getUL()));
            for (GroupsRegister.Entry.Record record : entry.getContents()) {
                void var14_61;
                void var12_39;
                AUID aUID = new AUID(record.getItem());
                Object var12_40 = null;
                if (defs.containsKey(aUID)) {
                    PropertyAliasDefinition padef = new PropertyAliasDefinition();
                    padef.setOriginalProperty(aUID);
                    PropertyAliasDefinition propertyAliasDefinition = padef;
                } else {
                    PropertyDefinition propertyDefinition = new PropertyDefinition();
                }
                var12_39.setIdentification(aUID);
                var12_39.setOptional(record.getOptional());
                if (record.getUniqueID() != null) {
                    var12_39.setUniqueIdentifier(record.getUniqueID());
                }
                var12_39.setLocalIdentification((int)(record.getLocalTag() == null ? 0L : record.getLocalTag()));
                ElementsRegister.Entry element = er.getEntryByUL(record.getItem());
                if (element == null) {
                    RegisterEvent registerEvent = new RegisterEvent(EventKind.UNKNOWN_ELEMENT, String.format("Undefined Element %s for Group %s", record.getItem(), entry.getUL()));
                    RegisterImporter.handleEvent(evthandler, registerEvent);
                    continue;
                }
                var12_39.setDescription(element.getDefinition());
                var12_39.setName(element.getName());
                var12_39.setSymbol(element.getSymbol());
                if (element.getTypeUL() == null) {
                    RegisterEvent registerEvent = new RegisterEvent(EventKind.UNKNOWN_TYPE, String.format("Missing Type UL at Element %s for Group %s", record.getItem(), entry.getUL()));
                    RegisterImporter.handleEvent(evthandler, registerEvent);
                    continue;
                }
                var12_39.setType(new AUID(element.getTypeUL()));
                var12_39.setMemberOf(cdef.getIdentification());
                var12_39.setNamespace(element.getNamespaceName());
                RegisterImporter._add(defs, (Definition)var12_39);
                HashSet<AUID> hashSet = isReferencedBy.get(var12_39.getType());
                if (hashSet == null) {
                    HashSet hashSet2 = new HashSet();
                    isReferencedBy.put(var12_39.getType(), hashSet2);
                }
                var14_61.add(var12_39.getIdentification());
            }
            RegisterImporter._add(defs, cdef);
        }
        iterator = tr.getEntries().iterator();
        block15: while (true) {
            HashSet<AUID> references;
            Definition tdef;
            TypesRegister.Entry entry;
            block47: {
                Iterator<? extends TypesRegister.Entry.Facet> iterator2;
                block61: {
                    block48: {
                        block63: {
                            block62: {
                                block60: {
                                    block59: {
                                        block58: {
                                            block57: {
                                                block56: {
                                                    block55: {
                                                        block54: {
                                                            block53: {
                                                                block52: {
                                                                    block51: {
                                                                        block50: {
                                                                            block49: {
                                                                                if (!iterator.hasNext()) break block48;
                                                                                entry = (TypesRegister.Entry)iterator.next();
                                                                                if (!entry.getKind().equals((Object)TypesRegister.Entry.Kind.LEAF)) continue;
                                                                                tdef = null;
                                                                                references = new HashSet<AUID>();
                                                                                if (!"Rename".equals(entry.getTypeKind())) break block49;
                                                                                tdef = new RenameTypeDefinition();
                                                                                ((RenameTypeDefinition)tdef).setRenamedType(new AUID(entry.getBaseType()));
                                                                                references.add(((RenameTypeDefinition)tdef).getRenamedType());
                                                                                break block47;
                                                                            }
                                                                            if (!"Integer".equals(entry.getTypeKind())) break block50;
                                                                            tdef = new IntegerTypeDefinition();
                                                                            ((IntegerTypeDefinition)tdef).setSigned(entry.getTypeQualifiers().contains((Object)TypesRegister.Entry.TypeQualifiers.isSigned));
                                                                            switch (entry.getTypeSize().intValue()) {
                                                                                case 1: {
                                                                                    ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.ONE);
                                                                                    break block47;
                                                                                }
                                                                                case 2: {
                                                                                    ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.TWO);
                                                                                    break block47;
                                                                                }
                                                                                case 4: {
                                                                                    ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.FOUR);
                                                                                    break block47;
                                                                                }
                                                                                case 8: {
                                                                                    ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.EIGHT);
                                                                                    break block47;
                                                                                }
                                                                                default: {
                                                                                    RegisterEvent registerEvent = new RegisterEvent(EventKind.BAD_TYPE_SIZE, String.format("Type size %d is not supported for Type UL %s.", entry.getTypeSize().intValue(), entry.getUL().toString()));
                                                                                    RegisterImporter.handleEvent(evthandler, registerEvent);
                                                                                    break;
                                                                                }
                                                                            }
                                                                            continue;
                                                                        }
                                                                        if (!"Float".equals(entry.getTypeKind())) break block51;
                                                                        tdef = new FloatTypeDefinition();
                                                                        switch (entry.getTypeSize().intValue()) {
                                                                            case 2: {
                                                                                ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.HALF);
                                                                                break block47;
                                                                            }
                                                                            case 4: {
                                                                                ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.SINGLE);
                                                                                break block47;
                                                                            }
                                                                            case 8: {
                                                                                ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.DOUBLE);
                                                                                break block47;
                                                                            }
                                                                            default: {
                                                                                RegisterEvent registerEvent = new RegisterEvent(EventKind.BAD_TYPE_SIZE, String.format("Type size %d is not supported for Type UL %s.", entry.getTypeSize().intValue(), entry.getUL().toString()));
                                                                                RegisterImporter.handleEvent(evthandler, registerEvent);
                                                                                break;
                                                                            }
                                                                        }
                                                                        continue;
                                                                    }
                                                                    if (!"LensSerialFloat".equals(entry.getTypeKind())) break block52;
                                                                    tdef = new LensSerialFloatTypeDefinition();
                                                                    break block47;
                                                                }
                                                                if (!"Record".equals(entry.getTypeKind())) break block53;
                                                                tdef = new RecordTypeDefinition();
                                                                for (TypesRegister.Entry.Facet facet : entry.getFacets()) {
                                                                    RecordTypeDefinition.Member member = new RecordTypeDefinition.Member();
                                                                    member.setName(facet.getSymbol());
                                                                    member.setType(new AUID(facet.getType()));
                                                                    ((RecordTypeDefinition)tdef).addMember(member);
                                                                    references.add(member.getType());
                                                                }
                                                                break block47;
                                                            }
                                                            if (!"FixedArray".equals(entry.getTypeKind())) break block54;
                                                            tdef = new FixedArrayTypeDefinition();
                                                            ((FixedArrayTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                                                            ((FixedArrayTypeDefinition)tdef).setElementCount(entry.getTypeSize().intValue());
                                                            references.add(((FixedArrayTypeDefinition)tdef).getElementType());
                                                            break block47;
                                                        }
                                                        if (!"VariableArray".equals(entry.getTypeKind())) break block55;
                                                        tdef = new VariableArrayTypeDefinition();
                                                        ((VariableArrayTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                                                        references.add(((VariableArrayTypeDefinition)tdef).getElementType());
                                                        break block47;
                                                    }
                                                    if (!"Set".equals(entry.getTypeKind())) break block56;
                                                    tdef = new SetTypeDefinition();
                                                    ((SetTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                                                    references.add(((SetTypeDefinition)tdef).getElementType());
                                                    break block47;
                                                }
                                                if (!"Indirect".equals(entry.getTypeKind())) break block57;
                                                tdef = new IndirectTypeDefinition();
                                                break block47;
                                            }
                                            if (!"Opaque".equals(entry.getTypeKind())) break block58;
                                            tdef = new OpaqueTypeDefinition();
                                            break block47;
                                        }
                                        if (!"Stream".equals(entry.getTypeKind())) break block59;
                                        tdef = new StreamTypeDefinition();
                                        break block47;
                                    }
                                    if (!"WeakReference".equals(entry.getTypeKind())) break block60;
                                    tdef = new WeakReferenceTypeDefinition();
                                    if (entry.getBaseType() == null) {
                                        throw new Exception(String.format("Missing base type for Type %s", entry.getUL()));
                                    }
                                    ((WeakReferenceTypeDefinition)tdef).setReferencedType(new AUID(entry.getBaseType()));
                                    references.add(((WeakReferenceTypeDefinition)tdef).getReferencedType());
                                    iterator2 = entry.getFacets().iterator();
                                    break block61;
                                }
                                if (!"StrongReference".equals(entry.getTypeKind())) break block62;
                                tdef = new StrongReferenceTypeDefinition();
                                ((StrongReferenceTypeDefinition)tdef).setReferenceType(new AUID(entry.getBaseType()));
                                references.add(((StrongReferenceTypeDefinition)tdef).getReferencedType());
                                break block47;
                            }
                            if (!"Enumeration".equals(entry.getTypeKind())) break block63;
                            if (entry.getBaseType().equals(UL.fromURN("urn:smpte:ul:060E2B34.01040101.01030100.00000000"))) {
                                ArrayList<ExtendibleEnumerationTypeDefinition.Element> arrayList = new ArrayList<ExtendibleEnumerationTypeDefinition.Element>();
                                tdef = new ExtendibleEnumerationTypeDefinition(arrayList);
                                break block47;
                            } else if (entry.getBaseType().equalsWithMask(UL.fromURN("urn:smpte:ul:060e2b34.01040101.01010000.00000000"), 65472)) {
                                ArrayList<EnumerationTypeDefinition.Element> arrayList = new ArrayList<EnumerationTypeDefinition.Element>();
                                for (TypesRegister.Entry.Facet facet : entry.getFacets()) {
                                    EnumerationTypeDefinition.Element m = new EnumerationTypeDefinition.Element();
                                    m.setName(facet.getSymbol());
                                    m.setValue(Integer.decode(facet.getValue()));
                                    arrayList.add(m);
                                }
                                tdef = new EnumerationTypeDefinition(arrayList);
                                ((EnumerationTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                                references.add(((EnumerationTypeDefinition)tdef).getElementType());
                                break block47;
                            } else {
                                RegisterEvent registerEvent = new RegisterEvent(EventKind.BAD_ENUM_TYPE, String.format("Enumeration base type %s is neither integer nor AUID for Type UL %s.", entry.getBaseType(), entry.getUL().toString()));
                                RegisterImporter.handleEvent(evthandler, registerEvent);
                                continue;
                            }
                        }
                        if ("Character".equals(entry.getTypeKind())) {
                            tdef = new CharacterTypeDefinition();
                            break block47;
                        } else if ("String".equals(entry.getTypeKind())) {
                            tdef = new StringTypeDefinition();
                            ((StringTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                            references.add(((StringTypeDefinition)tdef).getElementType());
                            break block47;
                        } else {
                            RegisterEvent registerEvent = new RegisterEvent(EventKind.UNKNOWN_TYPE_KIND, String.format("Unknown type kind of %s for Type UL %s.", entry.getTypeKind(), entry.getUL().toString()));
                            RegisterImporter.handleEvent(evthandler, registerEvent);
                            continue;
                        }
                    }
                    for (AUID aUID : isReferencedBy.keySet()) {
                        if (defs.containsKey(aUID)) continue;
                        RegisterImporter._prune(defs, isReferencedBy, aUID);
                    }
                    break;
                }
                while (iterator2.hasNext()) {
                    RegisterEvent evt;
                    void var12_47;
                    TypesRegister.Entry.Facet facet = iterator2.next();
                    Object var12_45 = null;
                    if (facet.getValue() != null) {
                        UL uL = UL.fromURN(facet.getValue());
                    }
                    if (var12_47 == null) {
                        evt = new RegisterEvent(EventKind.UNKNOWN_TARGET_SET, String.format("Missing Target Set UL at Type %s", entry.getUL().toString()));
                        RegisterImporter.handleEvent(evthandler, evt);
                        continue;
                    }
                    if (!((WeakReferenceTypeDefinition)tdef).getTargetSet().add(new AUID((UL)var12_47))) {
                        evt = new RegisterEvent(EventKind.DUP_TARGET_SET, String.format("Duplicate Target Set UL at Type %s", entry.getUL().toString()));
                        RegisterImporter.handleEvent(evthandler, evt);
                    }
                    references.add(new AUID((UL)var12_47));
                }
            }
            if (tdef != null) {
                tdef.setIdentification(new AUID(entry.getUL()));
                tdef.setSymbol(entry.getSymbol());
                tdef.setName(entry.getName());
                tdef.setDescription(entry.getDefinition());
                tdef.setNamespace(entry.getNamespaceName());
                RegisterImporter._add(defs, tdef);
                Iterator iterator3 = references.iterator();
                while (true) {
                    void var12_51;
                    if (!iterator3.hasNext()) continue block15;
                    AUID aUID = (AUID)iterator3.next();
                    HashSet<AUID> hashSet = isReferencedBy.get(aUID);
                    if (hashSet == null) {
                        HashSet hashSet3 = new HashSet();
                        isReferencedBy.put(aUID, hashSet3);
                    }
                    var12_51.add(tdef.getIdentification());
                }
            }
            RegisterEvent registerEvent = new RegisterEvent(EventKind.TYPE_IMPORT_FAILED, String.format("Type UL %s import failed", entry.getUL().toString()));
            RegisterImporter.handleEvent(evthandler, registerEvent);
        }
        MetaDictionaryCollection mds = new MetaDictionaryCollection();
        long l = 0L;
        Iterator<Object> iterator4 = defs.values().iterator();
        block21: while (iterator4.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator4.next();
            Iterator iterator5 = arrayList.iterator();
            while (true) {
                if (!iterator5.hasNext()) continue block21;
                Definition definition = (Definition)iterator5.next();
                try {
                    mds.addDefinition(definition);
                }
                catch (DuplicateSymbolException dse) {
                    String string = "dup" + definition.getSymbol() + l++;
                    RegisterEvent evt = new RegisterEvent(EventKind.DUPLICATE_SYMBOL, String.format("Duplicate symbol %s (%s) renamed %s", definition.getSymbol(), definition.getNamespace().toASCIIString(), string));
                    RegisterImporter.handleEvent(evthandler, evt);
                    definition.setSymbol(string);
                    mds.addDefinition(definition);
                    continue;
                }
                break;
            }
            break;
        }
        return mds;
    }

    private static void _add(Map<AUID, ArrayList<Definition>> defs, Definition def) {
        ArrayList<Definition> ad = defs.get(def.getIdentification());
        if (ad == null) {
            ad = new ArrayList();
            defs.put(def.getIdentification(), ad);
        }
        ad.add(def);
    }

    private static void _prune(Map<AUID, ArrayList<Definition>> defs, HashMap<AUID, HashSet<AUID>> isReferencedBy, AUID aref) {
        if (isReferencedBy.containsKey(aref)) {
            for (AUID entry : isReferencedBy.get(aref)) {
                RegisterImporter._prune(defs, isReferencedBy, entry);
            }
        }
        defs.remove(aref);
    }

    public static class RegisterEvent
    extends BasicEvent {
        public RegisterEvent(EventKind kind, String message) {
            super(kind.severity, kind, message);
        }
    }

    public static enum EventKind {
        UNKNOWN_ELEMENT(Event.Severity.WARN),
        UNKNOWN_TYPE(Event.Severity.WARN),
        UNKNOWN_TARGET_SET(Event.Severity.WARN),
        DUP_TARGET_SET(Event.Severity.WARN),
        UNKNOWN_TYPE_KIND(Event.Severity.ERROR),
        TYPE_IMPORT_FAILED(Event.Severity.ERROR),
        DUPLICATE_SYMBOL(Event.Severity.ERROR),
        BAD_ENUM_TYPE(Event.Severity.ERROR),
        BAD_TYPE_SIZE(Event.Severity.ERROR);

        public final Event.Severity severity;

        private EventKind(Event.Severity severity) {
            this.severity = severity;
        }
    }
}

