/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml;

import com.sandflow.smpte.klv.Group;
import com.sandflow.smpte.klv.KLVInputStream;
import com.sandflow.smpte.klv.LocalSet;
import com.sandflow.smpte.klv.LocalTagRegister;
import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.mxf.FillItem;
import com.sandflow.smpte.mxf.PartitionPack;
import com.sandflow.smpte.mxf.PrimerPack;
import com.sandflow.smpte.mxf.Set;
import com.sandflow.smpte.regxml.FragmentBuilder;
import com.sandflow.smpte.regxml.dict.DefinitionResolver;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.CountingInputStream;
import com.sandflow.smpte.util.UL;
import com.sandflow.smpte.util.UUID;
import com.sandflow.util.events.BasicEvent;
import com.sandflow.util.events.Event;
import com.sandflow.util.events.EventHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class MXFFragmentBuilder {
    private static final Logger LOG = Logger.getLogger(MXFFragmentBuilder.class.getName());
    private static final UL INDEX_TABLE_SEGMENT_UL = UL.fromURN("urn:smpte:ul:060e2b34.02530101.0d010201.01100100");
    private static final UL PREFACE_KEY = UL.fromURN("urn:smpte:ul:060e2b34.027f0101.0d010101.01012f00");

    static void handleEvent(EventHandler handler, Event evt) throws MXFException {
        if (handler != null ? !handler.handle(evt) || evt.getSeverity() == Event.Severity.FATAL : evt.getSeverity() == Event.Severity.ERROR || evt.getSeverity() == Event.Severity.FATAL) {
            throw new MXFException(evt.getMessage());
        }
    }

    public static DocumentFragment fromInputStream(InputStream mxfpartition, DefinitionResolver defresolver, UL rootclasskey, Document document) throws IOException, KLVException, MXFException, FragmentBuilder.RuleException {
        return MXFFragmentBuilder.fromInputStream(mxfpartition, defresolver, null, rootclasskey, document);
    }

    public static DocumentFragment fromInputStream(InputStream mxfpartition, DefinitionResolver defresolver, FragmentBuilder.AUIDNameResolver enumnameresolver, UL rootclasskey, Document document) throws IOException, KLVException, MXFException, FragmentBuilder.RuleException {
        EventHandler handler = new EventHandler(){

            @Override
            public boolean handle(Event evt) {
                switch (evt.getSeverity()) {
                    case ERROR: 
                    case FATAL: {
                        LOG.severe(evt.getMessage());
                        break;
                    }
                    case INFO: {
                        LOG.info(evt.getMessage());
                        break;
                    }
                    case WARN: {
                        LOG.warning(evt.getMessage());
                    }
                }
                return true;
            }
        };
        return MXFFragmentBuilder.fromInputStream(mxfpartition, defresolver, enumnameresolver, handler, rootclasskey, document);
    }

    public static DocumentFragment fromInputStream(InputStream mxfpartition, DefinitionResolver defresolver, FragmentBuilder.AUIDNameResolver enumnameresolver, EventHandler evthandler, UL rootclasskey, Document document) throws IOException, KLVException, MXFException, FragmentBuilder.RuleException {
        Group agroup;
        MXFEvent evt;
        Object t;
        Triplet t2;
        Triplet t3;
        CountingInputStream cis = new CountingInputStream(mxfpartition);
        KLVInputStream kis = new KLVInputStream(cis);
        PartitionPack pp = null;
        while ((t3 = kis.readTriplet()) != null && (pp = PartitionPack.fromTriplet(t3)) == null) {
        }
        if (pp == null) {
            MXFEvent evt2 = new MXFEvent(EventCodes.MISSING_PARTITION_PACK, "No Partition Pack found");
            MXFFragmentBuilder.handleEvent(evthandler, evt2);
        }
        cis.resetCount();
        LocalTagRegister localreg = null;
        while ((t2 = kis.readTriplet()) != null) {
            if (!FillItem.getKey().equalsIgnoreVersion(t2.getKey())) {
                localreg = PrimerPack.createLocalTagRegister(t2);
                break;
            }
            cis.resetCount();
        }
        if (localreg == null) {
            MXFEvent evt3 = new MXFEvent(EventCodes.MISSING_PRIMER_PACK, "No Primer Pack found");
            MXFFragmentBuilder.handleEvent(evthandler, evt3);
        }
        ArrayList<LocalSet> gs = new ArrayList<LocalSet>();
        HashMap<UUID, Set> setresolver = new HashMap<UUID, Set>();
        while (cis.getCount() < pp.getHeaderByteCount() && (t = kis.readTriplet()) != null) {
            if (INDEX_TABLE_SEGMENT_UL.equalsIgnoreVersion(t.getKey())) {
                MXFEvent evt4 = new MXFEvent(EventCodes.UNEXPECTED_STRUCTURE, "Index Table Segment encountered before Header Byte Count bytes read");
                MXFFragmentBuilder.handleEvent(evthandler, evt4);
                break;
            }
            if (FillItem.getKey().equalsIgnoreVersion(t.getKey())) continue;
            try {
                LocalSet g = LocalSet.fromTriplet((Triplet)t, localreg);
                if (g != null) {
                    gs.add(g);
                    Set set = Set.fromGroup(g);
                    if (set == null) continue;
                    setresolver.put(set.getInstanceID(), set);
                    continue;
                }
                evt = new MXFEvent(EventCodes.GROUP_READ_FAILED, String.format("Failed to read Group: {0}", t.getKey().toString()));
                MXFFragmentBuilder.handleEvent(evthandler, evt);
            }
            catch (KLVException ke) {
                evt = new MXFEvent(EventCodes.GROUP_READ_FAILED, String.format("Failed to read Group %s with error %s", t.getKey().toString(), ke.getMessage()));
                MXFFragmentBuilder.handleEvent(evthandler, evt);
            }
        }
        t = gs.iterator();
        while (t.hasNext() && !(agroup = (Group)t.next()).getKey().equalsWithMask(PREFACE_KEY, 64255)) {
            if (agroup.getKey().isClass14()) continue;
            evt = new MXFEvent(EventCodes.UNEXPECTED_STRUCTURE, String.format("At least one non-class 14 Set %s was found between the Primer Pack and the Preface Set.", agroup.getKey()));
            MXFFragmentBuilder.handleEvent(evthandler, evt);
            break;
        }
        FragmentBuilder fb = new FragmentBuilder(defresolver, setresolver, enumnameresolver, evthandler);
        Group rootgroup = null;
        if (rootclasskey != null) {
            Iterator iter = gs.iterator();
            while (rootgroup == null && iter.hasNext()) {
                Definition def;
                Group g = (Group)iter.next();
                AUID gid = new AUID(g.getKey());
                while (rootgroup == null && gid != null && (def = defresolver.getDefinition(gid)) instanceof ClassDefinition) {
                    UL gul = def.getIdentification().asUL();
                    if (gul.equalsWithMask(rootclasskey, 64255)) {
                        rootgroup = g;
                        continue;
                    }
                    gid = ((ClassDefinition)def).getParentClass();
                }
            }
        } else {
            rootgroup = (Group)gs.get(0);
        }
        if (rootgroup == null) {
            evt = new MXFEvent(EventCodes.MISSING_ROOT_OBJECT, "No Root Object found");
            MXFFragmentBuilder.handleEvent(evthandler, evt);
        }
        return fb.fromTriplet(rootgroup, document);
    }

    public static class MXFException
    extends Exception {
        public MXFException(String msg) {
            super(msg);
        }
    }

    public static class MXFEvent
    extends BasicEvent {
        public MXFEvent(EventCodes kind, String message) {
            super(kind.severity, kind, message);
        }
    }

    public static enum EventCodes {
        MISSING_ROOT_OBJECT(Event.Severity.FATAL),
        MISSING_PARTITION_PACK(Event.Severity.FATAL),
        MISSING_PRIMER_PACK(Event.Severity.FATAL),
        UNEXPECTED_STRUCTURE(Event.Severity.ERROR),
        GROUP_READ_FAILED(Event.Severity.ERROR);

        public final Event.Severity severity;

        private EventCodes(Event.Severity severity) {
            this.severity = severity;
        }
    }
}

