/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.mxf;

import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.mxf.MXFInputStream;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class PartitionPack {
    private static final UL KEY = new UL(new byte[]{6, 14, 43, 52, 2, 5, 1, 1, 13, 1, 2, 1, 1, 0, 0, 0});
    private int majorVersion;
    private int minorVersion;
    private long kagSize;
    private long thisPartition;
    private long previousPartition;
    private long footerPartition;
    private long headerByteCount;
    private long indexByteCount;
    private long indexSID;
    private long bodyOffset;
    private long bodySID;
    private UL operationalPattern;
    private ArrayList<UL> essenceContainers = new ArrayList();
    private Kind kind;
    private Status status;

    public static UL getKey() {
        return KEY;
    }

    public static PartitionPack fromTriplet(Triplet triplet) throws KLVException {
        PartitionPack pp = new PartitionPack();
        if (!KEY.equalsWithMask(triplet.getKey(), 65273)) {
            return null;
        }
        switch (triplet.getKey().asUL().getValueOctet(14)) {
            case 1: {
                pp.setStatus(Status.OPEN_INCOMPLETE);
                break;
            }
            case 2: {
                pp.setStatus(Status.CLOSED_INCOMPLETE);
                break;
            }
            case 3: {
                pp.setStatus(Status.OPEN_COMPLETE);
                break;
            }
            case 4: {
                pp.setStatus(Status.CLOSED_COMPLETE);
                break;
            }
            default: {
                return null;
            }
        }
        switch (triplet.getKey().asUL().getValueOctet(13)) {
            case 2: {
                pp.setKind(Kind.HEADER);
                break;
            }
            case 3: {
                pp.setKind(Kind.BODY);
                break;
            }
            case 4: {
                pp.setKind(Kind.FOOTER);
                if (pp.getStatus() != Status.OPEN_COMPLETE && pp.getStatus() != Status.OPEN_INCOMPLETE) break;
                return null;
            }
            default: {
                return null;
            }
        }
        MXFInputStream kis = new MXFInputStream(triplet.getValueAsStream());
        try {
            pp.setMajorVersion(kis.readUnsignedShort());
            pp.setMinorVersion(kis.readUnsignedShort());
            pp.setKagSize(kis.readUnsignedInt());
            pp.setThisPartition(kis.readLong());
            pp.setPreviousPartition(kis.readLong());
            pp.setFooterPartition(kis.readLong());
            pp.setHeaderByteCount(kis.readLong());
            pp.setIndexByteCount(kis.readLong());
            pp.setIndexSID(kis.readUnsignedInt());
            pp.setBodyOffset(kis.readLong());
            pp.setBodySID(kis.readLong());
            pp.setOperationalPattern(kis.readUL());
            pp.setEssenceContainers(kis.readBatch());
        }
        catch (IOException e) {
            throw new KLVException(e);
        }
        return pp;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public long getKagSize() {
        return this.kagSize;
    }

    public void setKagSize(long kagSize) {
        this.kagSize = kagSize;
    }

    public long getThisPartition() {
        return this.thisPartition;
    }

    public void setThisPartition(long thisPartition) {
        this.thisPartition = thisPartition;
    }

    public long getPreviousPartition() {
        return this.previousPartition;
    }

    public void setPreviousPartition(long previousPartition) {
        this.previousPartition = previousPartition;
    }

    public long getFooterPartition() {
        return this.footerPartition;
    }

    public void setFooterPartition(long footerPartition) {
        this.footerPartition = footerPartition;
    }

    public long getHeaderByteCount() {
        return this.headerByteCount;
    }

    public void setHeaderByteCount(long headerByteCount) {
        this.headerByteCount = headerByteCount;
    }

    public long getIndexByteCount() {
        return this.indexByteCount;
    }

    public void setIndexByteCount(long indexByteCount) {
        this.indexByteCount = indexByteCount;
    }

    public long getIndexSID() {
        return this.indexSID;
    }

    public void setIndexSID(long indexSID) {
        this.indexSID = indexSID;
    }

    public long getBodyOffset() {
        return this.bodyOffset;
    }

    public void setBodyOffset(long bodyOffset) {
        this.bodyOffset = bodyOffset;
    }

    public long getBodySID() {
        return this.bodySID;
    }

    public void setBodySID(long bodySID) {
        this.bodySID = bodySID;
    }

    public UL getOperationalPattern() {
        return this.operationalPattern;
    }

    public void setOperationalPattern(UL operationalPattern) {
        this.operationalPattern = operationalPattern;
    }

    public Collection<UL> getEssenceContainers() {
        return this.essenceContainers;
    }

    public void setEssenceContainers(Collection<UL> essenceContainers) {
        this.essenceContainers = new ArrayList<UL>(essenceContainers);
    }

    public static enum Status {
        OPEN_INCOMPLETE,
        CLOSED_INCOMPLETE,
        OPEN_COMPLETE,
        CLOSED_COMPLETE;

    }

    public static enum Kind {
        HEADER,
        BODY,
        FOOTER;

    }
}

