/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.util;

import com.sandflow.smpte.util.AUID;
import java.util.Arrays;
import java.util.regex.Pattern;

public class UL {
    private static final Pattern URN_PATTERN = Pattern.compile("urn:smpte:ul:[a-fA-F0-9]{8}\\.[a-fA-F0-9]{8}\\.[a-fA-F0-9]{8}\\.[a-fA-F0-9]{8}");
    private static final Pattern DOTVALUE_PATTERN = Pattern.compile("[a-fA-F0-9]{2}(\\.[a-fA-F0-9]{2}){15}");
    private static final int CATEGORY_DESIGNATOR_BYTE = 4;
    private static final int REGISTRY_DESIGNATOR_BYTE = 5;
    private final byte[] value;

    public static UL fromURN(String urn) {
        byte[] ul = new byte[16];
        if (URN_PATTERN.matcher(urn).matches()) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    ul[4 * i + j] = (byte)Integer.parseInt(urn.substring(13 + i * 9 + 2 * j, 13 + i * 9 + 2 * j + 2), 16);
                }
            }
            return new UL(ul);
        }
        return null;
    }

    public static UL fromDotValue(String val) {
        byte[] ul = new byte[16];
        if (DOTVALUE_PATTERN.matcher(val).matches()) {
            for (int i = 0; i < 16; ++i) {
                ul[i] = (byte)Integer.parseInt(val.substring(3 * i, 3 * i + 2), 16);
            }
            return new UL(ul);
        }
        return null;
    }

    public boolean isGroup() {
        return this.getValueOctet(4) == 2;
    }

    public boolean isLocalSet() {
        return this.isGroup() && (this.getRegistryDesignator() & 7) == 3;
    }

    public int getRegistryDesignator() {
        return this.getValueOctet(5);
    }

    private UL() {
        this.value = new byte[16];
    }

    public UL(byte[] ul) {
        this.value = Arrays.copyOf(ul, 16);
    }

    public boolean equalsIgnoreVersion(UL ul) {
        int i;
        for (i = 0; i < 7; ++i) {
            if (this.value[i] == ul.value[i]) continue;
            return false;
        }
        for (i = 8; i < 16; ++i) {
            if (this.value[i] == ul.value[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreVersion(AUID auid) {
        return auid.isUL() && this.equalsIgnoreVersion(auid.asUL());
    }

    public byte getVersion() {
        return this.getValueOctet(7);
    }

    public boolean equalsWithMask(UL ul, int bytemask) {
        for (int i = 0; i < 15; ++i) {
            if ((bytemask & 0x8000) != 0 && this.value[i] != ul.value[i]) {
                return false;
            }
            bytemask <<= 1;
        }
        return true;
    }

    public boolean equalsWithMask(AUID auid, int bytemask) {
        return auid.isUL() && this.equalsWithMask(auid.asUL(), bytemask);
    }

    public boolean equals(UL ul) {
        return Arrays.equals(ul.value, this.value);
    }

    public boolean equals(AUID auid) {
        return auid.equals(this);
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte getValueOctet(int i) {
        return this.value[i];
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UL other = (UL)obj;
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        return String.format("urn:smpte:ul:%02x%02x%02x%02x.%02x%02x%02x%02x.%02x%02x%02x%02x.%02x%02x%02x%02x", this.value[0], this.value[1], this.value[2], this.value[3], this.value[4], this.value[5], this.value[6], this.value[7], this.value[8], this.value[9], this.value[10], this.value[11], this.value[12], this.value[13], this.value[14], this.value[15]);
    }

    public boolean isClass14() {
        return this.getValueOctet(8) == 14;
    }

    public boolean isClass15() {
        return this.getValueOctet(8) == 15;
    }

    public boolean isClass13() {
        return this.getValueOctet(8) == 13;
    }
}

