/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.klv;

import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.util.AUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidParameterException;

public class MemoryTriplet
implements Triplet {
    private final AUID key;
    private final byte[] value;

    public MemoryTriplet(AUID key, byte[] value) {
        if (key == null || value == null) {
            throw new InvalidParameterException("Triplet muse have key and value.");
        }
        this.key = key;
        this.value = value;
    }

    @Override
    public AUID getKey() {
        return this.key;
    }

    @Override
    public long getLength() {
        return this.value.length;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public InputStream getValueAsStream() {
        return new ByteArrayInputStream(this.value);
    }
}

