/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.util;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;

public class ExcelCSVParser {
    Reader reader;

    public ExcelCSVParser(Reader reader) {
        this.reader = reader;
    }

    public AbstractList<String> getLine() throws SyntaxException, IOException {
        int c;
        State s = State.IN_PFIELD;
        StringBuilder field = new StringBuilder();
        ArrayList<String> strs = new ArrayList<String>();
        boolean done = false;
        while (!done && (c = this.reader.read()) != -1) {
            block0 : switch (s) {
                case EOL: {
                    if (c != 10) {
                        throw new SyntaxException();
                    }
                    done = true;
                }
                case DQ_IN_QFIELD: {
                    if (c == 34) {
                        field.append('\"');
                        s = State.IN_QFIELD;
                        break;
                    }
                    s = State.IN_PFIELD;
                }
                case IN_PFIELD: {
                    switch (c) {
                        case 13: {
                            s = State.EOL;
                        }
                        case 44: {
                            if (field.length() == 0) {
                                strs.add(null);
                                break block0;
                            }
                            strs.add(field.toString());
                            field.setLength(0);
                            break block0;
                        }
                        case 34: {
                            s = State.IN_QFIELD;
                            break block0;
                        }
                    }
                    field.append((char)c);
                    break;
                }
                case IN_QFIELD: {
                    if (c == 34) {
                        s = State.DQ_IN_QFIELD;
                        break;
                    }
                    field.append((char)c);
                }
            }
        }
        if (done) {
            return strs;
        }
        return null;
    }

    private static enum State {
        IN_QFIELD,
        DQ_IN_QFIELD,
        IN_PFIELD,
        EOL;

    }

    public static class SyntaxException
    extends Exception {
    }
}

