/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.util;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    long count = 0L;
    long markCount = 0L;
    InputStream is;

    public CountingInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public synchronized void mark(int i) {
        this.markCount = this.count;
        this.is.mark(i);
    }

    @Override
    public long skip(long l) throws IOException {
        long sb = this.is.skip(l);
        if (sb >= 0L) {
            this.count += sb;
        }
        return sb;
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        int sb = this.is.read(bytes, i, i1);
        if (sb >= 0) {
            this.count += (long)sb;
        }
        return sb;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int sb = this.is.read(bytes);
        if (sb >= 0) {
            this.count += (long)sb;
        }
        return sb;
    }

    @Override
    public int read() throws IOException {
        int sb = this.is.read();
        if (sb >= 0) {
            ++this.count;
        }
        return sb;
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.count = this.markCount;
        this.is.reset();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    public long getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0L;
    }
}

