/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict.importers;

import com.sandflow.smpte.register.ElementsRegister;
import com.sandflow.smpte.register.GroupsRegister;
import com.sandflow.smpte.register.TypesRegister;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.regxml.dict.definitions.CharacterTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.EnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ExtendibleEnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FixedArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IndirectTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IntegerTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.LensSerialFloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.OpaqueTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyAliasDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RecordTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RenameTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.SetTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StreamTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StringTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StrongReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.VariableArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.WeakReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.exceptions.DuplicateSymbolException;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import com.sandflow.util.events.BasicEvent;
import com.sandflow.util.events.Event;
import com.sandflow.util.events.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RegisterImporter {
    private static final Logger LOGGER = Logger.getLogger(RegisterImporter.class.getName());

    static void handleEvent(EventHandler handler, Event evt) throws Exception {
        if (handler != null ? !handler.handle(evt) || evt.getSeverity() == Event.Severity.FATAL : evt.getSeverity() == Event.Severity.ERROR || evt.getSeverity() == Event.Severity.FATAL) {
            throw new Exception(evt.getMessage());
        }
    }

    public static MetaDictionaryCollection fromRegister(TypesRegister tr, GroupsRegister gr, ElementsRegister er) throws Exception {
        EventHandler handler = new EventHandler(){

            @Override
            public boolean handle(Event evt) {
                switch (evt.getSeverity()) {
                    case ERROR: 
                    case FATAL: {
                        LOGGER.severe(evt.getMessage());
                        break;
                    }
                    case INFO: {
                        LOGGER.info(evt.getMessage());
                        break;
                    }
                    case WARN: {
                        LOGGER.warning(evt.getMessage());
                    }
                }
                return true;
            }
        };
        return RegisterImporter.fromRegister(tr, gr, er, handler);
    }

    public static MetaDictionaryCollection fromRegister(TypesRegister tr, GroupsRegister gr, ElementsRegister er, EventHandler evthandler) throws Exception {
        LinkedHashMap<AUID, ArrayList<Definition>> defs = new LinkedHashMap<AUID, ArrayList<Definition>>();
        HashMap<AUID, HashSet<AUID>> isReferencedBy = new HashMap<AUID, HashSet<AUID>>();
        for (GroupsRegister.Entry entry : gr.getEntries()) {
            if (entry.getKind().equals((Object)GroupsRegister.Entry.Kind.NODE) || entry.getUL().isClass14() || entry.getUL().isClass15() || !entry.getKlvSyntax().contains((byte)83)) continue;
            ClassDefinition cdef = new ClassDefinition();
            if (entry.isConcrete() != null) {
                cdef.setConcrete(entry.isConcrete());
            } else {
                cdef.setConcrete(true);
            }
            cdef.setDescription(entry.getDefinition());
            cdef.setName(entry.getName());
            cdef.setSymbol(entry.getSymbol());
            cdef.setNamespace(entry.getNamespaceName());
            if (entry.getParent() != null) {
                cdef.setParentClass(new AUID(entry.getParent()));
            }
            cdef.setIdentification(new AUID(entry.getUL()));
            for (GroupsRegister.Entry.Record record : entry.getContents()) {
                RegisterEvent evt;
                AUID aUID = new AUID(record.getItem());
                PropertyDefinition pdef = null;
                if (defs.containsKey(aUID)) {
                    PropertyAliasDefinition padef = new PropertyAliasDefinition();
                    padef.setOriginalProperty(aUID);
                    pdef = padef;
                } else {
                    pdef = new PropertyDefinition();
                }
                pdef.setIdentification(aUID);
                pdef.setOptional(record.getOptional());
                if (record.getUniqueID() != null) {
                    pdef.setUniqueIdentifier(record.getUniqueID());
                }
                pdef.setLocalIdentification((int)(record.getLocalTag() == null ? 0L : record.getLocalTag()));
                ElementsRegister.Entry element = er.getEntryByUL(record.getItem());
                if (element == null) {
                    evt = new RegisterEvent(EventKind.UNKNOWN_ELEMENT, String.format("Undefined Element %s for Group %s", record.getItem(), entry.getUL()));
                    RegisterImporter.handleEvent(evthandler, evt);
                    continue;
                }
                pdef.setDescription(element.getDefinition());
                pdef.setName(element.getName());
                pdef.setSymbol(element.getSymbol());
                if (element.getTypeUL() == null) {
                    evt = new RegisterEvent(EventKind.UNKNOWN_TYPE, String.format("Missing Type UL at Element %s for Group %s", record.getItem(), entry.getUL()));
                    RegisterImporter.handleEvent(evthandler, evt);
                    continue;
                }
                pdef.setType(new AUID(element.getTypeUL()));
                pdef.setMemberOf(cdef.getIdentification());
                pdef.setNamespace(element.getNamespaceName());
                RegisterImporter._add(defs, pdef);
            }
            RegisterImporter._add(defs, cdef);
        }
        for (TypesRegister.Entry entry : tr.getEntries()) {
            HashSet<AUID> references;
            Definition tdef;
            block66: {
                block68: {
                    block67: {
                        block65: {
                            if (!entry.getKind().equals((Object)TypesRegister.Entry.Kind.LEAF)) continue;
                            tdef = null;
                            references = new HashSet<AUID>();
                            if (!"Rename".equals(entry.getTypeKind())) break block65;
                            tdef = new RenameTypeDefinition();
                            ((RenameTypeDefinition)tdef).setRenamedType(new AUID(entry.getBaseType()));
                            references.add(((RenameTypeDefinition)tdef).getRenamedType());
                            break block66;
                        }
                        if (!"Integer".equals(entry.getTypeKind())) break block67;
                        tdef = new IntegerTypeDefinition();
                        ((IntegerTypeDefinition)tdef).setSigned(entry.getTypeQualifiers().contains((Object)TypesRegister.Entry.TypeQualifiers.isSigned));
                        switch (entry.getTypeSize().intValue()) {
                            case 1: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.ONE);
                                break block66;
                            }
                            case 2: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.TWO);
                                break block66;
                            }
                            case 4: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.FOUR);
                                break block66;
                            }
                            case 8: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.EIGHT);
                                break block66;
                            }
                            default: {
                                throw new Exception("Illegal Type Size.");
                            }
                        }
                    }
                    if (!"Float".equals(entry.getTypeKind())) break block68;
                    tdef = new FloatTypeDefinition();
                    switch (entry.getTypeSize().intValue()) {
                        case 2: {
                            ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.HALF);
                            break block66;
                        }
                        case 4: {
                            ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.SINGLE);
                            break block66;
                        }
                        case 8: {
                            ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.DOUBLE);
                            break block66;
                        }
                        default: {
                            throw new Exception("Illegal Type Size.");
                        }
                    }
                }
                if ("LensSerialFloat".equals(entry.getTypeKind())) {
                    tdef = new LensSerialFloatTypeDefinition();
                } else if ("Record".equals(entry.getTypeKind())) {
                    tdef = new RecordTypeDefinition();
                    for (TypesRegister.Entry.Facet facet : entry.getFacets()) {
                        RecordTypeDefinition.Member m = new RecordTypeDefinition.Member();
                        m.setName(facet.getSymbol());
                        m.setType(new AUID(facet.getType()));
                        ((RecordTypeDefinition)tdef).addMember(m);
                        references.add(m.getType());
                    }
                } else if ("FixedArray".equals(entry.getTypeKind())) {
                    tdef = new FixedArrayTypeDefinition();
                    ((FixedArrayTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                    ((FixedArrayTypeDefinition)tdef).setElementCount(entry.getTypeSize().intValue());
                    references.add(((FixedArrayTypeDefinition)tdef).getElementType());
                } else if ("VariableArray".equals(entry.getTypeKind())) {
                    tdef = new VariableArrayTypeDefinition();
                    ((VariableArrayTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                    references.add(((VariableArrayTypeDefinition)tdef).getElementType());
                } else if ("Set".equals(entry.getTypeKind())) {
                    tdef = new SetTypeDefinition();
                    ((SetTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                    references.add(((SetTypeDefinition)tdef).getElementType());
                } else if ("Indirect".equals(entry.getTypeKind())) {
                    tdef = new IndirectTypeDefinition();
                } else if ("Opaque".equals(entry.getTypeKind())) {
                    tdef = new OpaqueTypeDefinition();
                } else if ("Stream".equals(entry.getTypeKind())) {
                    tdef = new StreamTypeDefinition();
                } else if ("WeakReference".equals(entry.getTypeKind())) {
                    tdef = new WeakReferenceTypeDefinition();
                    if (entry.getBaseType() == null) {
                        throw new Exception(String.format("Missing base type for Type %s", entry.getUL()));
                    }
                    ((WeakReferenceTypeDefinition)tdef).setReferencedType(new AUID(entry.getBaseType()));
                    references.add(((WeakReferenceTypeDefinition)tdef).getReferencedType());
                    for (TypesRegister.Entry.Facet facet : entry.getFacets()) {
                        UL ul = null;
                        if (facet.getValue() != null) {
                            ul = UL.fromURN(facet.getValue());
                        }
                        if (ul == null) {
                            RegisterEvent evt2 = new RegisterEvent(EventKind.UNKNOWN_TARGET_SET, String.format("Missing Target Set UL at Type %s", entry.getUL().toString()));
                            RegisterImporter.handleEvent(evthandler, evt2);
                            continue;
                        }
                        if (!((WeakReferenceTypeDefinition)tdef).getTargetSet().add(new AUID(ul))) {
                            RegisterEvent evt = new RegisterEvent(EventKind.DUP_TARGET_SET, String.format("Duplicate Target Set UL at Type %s", entry.getUL().toString()));
                            RegisterImporter.handleEvent(evthandler, evt);
                        }
                        references.add(new AUID(ul));
                    }
                } else if ("StrongReference".equals(entry.getTypeKind())) {
                    tdef = new StrongReferenceTypeDefinition();
                    ((StrongReferenceTypeDefinition)tdef).setReferenceType(new AUID(entry.getBaseType()));
                    references.add(((StrongReferenceTypeDefinition)tdef).getReferenceType());
                } else if ("Enumeration".equals(entry.getTypeKind())) {
                    if (entry.getBaseType().equals(UL.fromURN("urn:smpte:ul:060E2B34.01040101.01030100.00000000"))) {
                        ArrayList<ExtendibleEnumerationTypeDefinition.Element> arrayList = new ArrayList<ExtendibleEnumerationTypeDefinition.Element>();
                        tdef = new ExtendibleEnumerationTypeDefinition(arrayList);
                    } else {
                        ArrayList<EnumerationTypeDefinition.Element> arrayList = new ArrayList<EnumerationTypeDefinition.Element>();
                        for (TypesRegister.Entry.Facet f2 : entry.getFacets()) {
                            EnumerationTypeDefinition.Element m = new EnumerationTypeDefinition.Element();
                            m.setName(f2.getSymbol());
                            m.setValue(Integer.decode(f2.getValue()));
                            arrayList.add(m);
                        }
                        tdef = new EnumerationTypeDefinition(arrayList);
                        ((EnumerationTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                        references.add(((EnumerationTypeDefinition)tdef).getElementType());
                    }
                } else if ("Character".equals(entry.getTypeKind())) {
                    tdef = new CharacterTypeDefinition();
                } else if ("String".equals(entry.getTypeKind())) {
                    tdef = new StringTypeDefinition();
                    ((StringTypeDefinition)tdef).setElementType(new AUID(entry.getBaseType()));
                    references.add(((StringTypeDefinition)tdef).getElementType());
                } else {
                    RegisterEvent registerEvent = new RegisterEvent(EventKind.UNKNOWN_TYPE_KIND, String.format("Unknown type kind of %s for Type UL %s.", entry.getTypeKind(), entry.getUL().toString()));
                    RegisterImporter.handleEvent(evthandler, registerEvent);
                    continue;
                }
            }
            if (tdef != null) {
                tdef.setIdentification(new AUID(entry.getUL()));
                tdef.setSymbol(entry.getSymbol());
                tdef.setName(entry.getName());
                tdef.setDescription(entry.getDefinition());
                tdef.setNamespace(entry.getNamespaceName());
                RegisterImporter._add(defs, tdef);
                for (AUID aUID : references) {
                    HashSet<AUID> hs = isReferencedBy.get(aUID);
                    if (hs == null) {
                        hs = new HashSet();
                        isReferencedBy.put(aUID, hs);
                    }
                    hs.add(tdef.getIdentification());
                }
                continue;
            }
            RegisterEvent registerEvent = new RegisterEvent(EventKind.TYPE_IMPORT_FAILED, String.format("Type UL %s import failed", entry.getUL().toString()));
            RegisterImporter.handleEvent(evthandler, registerEvent);
        }
        for (AUID aUID : isReferencedBy.keySet()) {
            if (defs.containsKey(aUID)) continue;
            RegisterImporter._prune(defs, isReferencedBy, aUID);
        }
        MetaDictionaryCollection mds = new MetaDictionaryCollection();
        long l = 0L;
        for (ArrayList arrayList : defs.values()) {
            for (Definition def : arrayList) {
                try {
                    mds.addDefinition(def);
                }
                catch (DuplicateSymbolException dse) {
                    String newsym = "dup" + def.getSymbol() + l++;
                    RegisterEvent evt = new RegisterEvent(EventKind.DUPLICATE_SYMBOL, String.format("Duplicate symbol %s (%s) renamed %s", def.getSymbol(), def.getNamespace().toASCIIString(), newsym));
                    RegisterImporter.handleEvent(evthandler, evt);
                    def.setSymbol(newsym);
                    mds.addDefinition(def);
                }
            }
        }
        return mds;
    }

    private static void _add(Map<AUID, ArrayList<Definition>> defs, Definition def) {
        ArrayList<Definition> ad = defs.get(def.getIdentification());
        if (ad == null) {
            ad = new ArrayList();
            defs.put(def.getIdentification(), ad);
        }
        ad.add(def);
    }

    private static void _prune(Map<AUID, ArrayList<Definition>> defs, HashMap<AUID, HashSet<AUID>> isReferencedBy, AUID aref) {
        if (isReferencedBy.containsKey(aref)) {
            for (AUID entry : isReferencedBy.get(aref)) {
                RegisterImporter._prune(defs, isReferencedBy, entry);
            }
        }
        defs.remove(aref);
    }

    public static class RegisterEvent
    extends BasicEvent {
        public RegisterEvent(EventKind kind, String message) {
            super(kind.severity, kind, message);
        }
    }

    public static enum EventKind {
        UNKNOWN_ELEMENT(Event.Severity.WARN),
        UNKNOWN_TYPE(Event.Severity.WARN),
        UNKNOWN_TARGET_SET(Event.Severity.WARN),
        DUP_TARGET_SET(Event.Severity.WARN),
        UNKNOWN_TYPE_KIND(Event.Severity.ERROR),
        TYPE_IMPORT_FAILED(Event.Severity.ERROR),
        DUPLICATE_SYMBOL(Event.Severity.ERROR);

        public final Event.Severity severity;

        private EventKind(Event.Severity severity) {
            this.severity = severity;
        }
    }
}

