/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.mxf;

import com.sandflow.smpte.klv.KLVInputStream;
import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.mxf.PartitionPack;
import com.sandflow.smpte.mxf.RandomIndexPack;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;

public class MXFFiles {
    public static long seekFooterPartition(SeekableByteChannel mxffile) throws IOException, KLVException {
        long headeroffset = MXFFiles.seekHeaderPartition(mxffile);
        KLVInputStream kis = new KLVInputStream(Channels.newInputStream(mxffile));
        Triplet t = kis.readTriplet();
        if (t == null) {
            return -1L;
        }
        PartitionPack pp = PartitionPack.fromTriplet(t);
        if (pp == null) {
            return -1L;
        }
        if (pp.getFooterPartition() != 0L) {
            mxffile.position(headeroffset + pp.getFooterPartition());
            return mxffile.position();
        }
        mxffile.position(mxffile.size() - 4L);
        ByteBuffer bytes = ByteBuffer.allocate(4);
        if (mxffile.read(bytes) != bytes.limit()) {
            return -1L;
        }
        mxffile.position(mxffile.size() - (long)bytes.getInt(0));
        kis = new KLVInputStream(Channels.newInputStream(mxffile));
        t = kis.readTriplet();
        if (t == null) {
            return -1L;
        }
        RandomIndexPack rip = RandomIndexPack.fromTriplet(t);
        if (rip == null) {
            return -1L;
        }
        mxffile.position(rip.getOffsets().get(rip.getOffsets().size() - 1).getOffset());
        return mxffile.position();
    }

    public static long seekHeaderPartition(SeekableByteChannel mxffile) throws IOException {
        ByteBuffer ulbytes = ByteBuffer.allocate(16);
        long offset = mxffile.position();
        while (mxffile.read(ulbytes) == ulbytes.limit() && offset <= 65536L) {
            UL ul = new UL(ulbytes.array());
            if (ul.equalsWithMask(PartitionPack.getKey(), 65248)) {
                mxffile.position(offset);
                return offset;
            }
            mxffile.position(++offset);
        }
        return -1L;
    }
}

