/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.tools;

import com.sandflow.smpte.mxf.MXFFiles;
import com.sandflow.smpte.register.LabelsRegister;
import com.sandflow.smpte.regxml.FragmentBuilder;
import com.sandflow.smpte.regxml.MXFFragmentBuilder;
import com.sandflow.smpte.regxml.dict.MetaDictionary;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.tools.BuildVersionSingleton;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import java.io.FileReader;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class RegXMLDump {
    private static final Logger LOG = Logger.getLogger(RegXMLDump.class.getName());
    private static final UL ESSENCE_DESCRIPTOR_KEY = new UL(new byte[]{6, 14, 43, 52, 2, 1, 1, 1, 13, 1, 1, 1, 1, 1, 36, 0});
    private static final UL PREFACE_KEY = UL.fromURN("urn:smpte:ul:060e2b34.027f0101.0d010101.01012f00");
    private static final String USAGE = "Dump header metadata of an MXF file as a RegXML structure.\n  Usage:\n     RegXMLDump ( -all | -ed ) ( -header | -footer | -auto ) (-l labelsregister) -d regxmldictionary1 regxmldictionary2 regxmldictionary3 ... -i mxffile\n     RegXMLDump -?\n  Where:\n     -all: dumps all header metadata (default)\n     -ed: dumps only the first essence descriptor found\n     -l labelsregister: given a SMPTE labels register, inserts the symbol of labels as XML comment\n     -header: dumps metadata from the header partition (default)\n     -footer: dumps metadata from the footer partition\n     -auto: dumps metadata from the footer partition if available and from the header if not\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean error = false;
        TargetPartition selectedpartition = null;
        Boolean isEssenceDescriptorOnly = null;
        MetaDictionaryCollection mds = null;
        SeekableByteChannel f = null;
        FileReader labelreader = null;
        Path p = null;
        int i = 0;
        while (i < args.length) {
            if ("-?".equals(args[i])) {
                error = true;
                break;
            }
            if ("-ed".equals(args[i])) {
                if (isEssenceDescriptorOnly != null) {
                    error = true;
                    break;
                }
                isEssenceDescriptorOnly = true;
                ++i;
                continue;
            }
            if ("-all".equals(args[i])) {
                if (isEssenceDescriptorOnly != null) {
                    error = true;
                    break;
                }
                isEssenceDescriptorOnly = false;
                ++i;
                continue;
            }
            if ("-footer".equals(args[i])) {
                if (selectedpartition != null) {
                    error = true;
                    break;
                }
                selectedpartition = TargetPartition.FOOTER;
                ++i;
                continue;
            }
            if ("-auto".equals(args[i])) {
                if (selectedpartition != null) {
                    error = true;
                    break;
                }
                selectedpartition = TargetPartition.AUTO;
                ++i;
                continue;
            }
            if ("-header".equals(args[i])) {
                if (selectedpartition != null) {
                    error = true;
                    break;
                }
                selectedpartition = TargetPartition.HEADER;
                ++i;
                continue;
            }
            if ("-d".equals(args[i])) {
                if (mds != null) {
                    error = true;
                    break;
                }
                ++i;
                mds = new MetaDictionaryCollection();
                while (i < args.length && args[i].charAt(0) != '-') {
                    FileReader fr = new FileReader(args[i]);
                    mds.addDictionary(MetaDictionary.fromXML(fr));
                    ++i;
                }
                if (!mds.getDictionaries().isEmpty()) continue;
                error = true;
                break;
            }
            if ("-l".equals(args[i])) {
                if (labelreader != null) {
                    error = true;
                    break;
                }
                labelreader = new FileReader(args[++i]);
                ++i;
                continue;
            }
            if ("-i".equals(args[i])) {
                if (f != null || ++i >= args.length || args[i].charAt(0) == '-') {
                    error = true;
                    break;
                }
                if ((p = Paths.get(args[i++], new String[0])) == null) {
                    error = true;
                    break;
                }
                f = Files.newByteChannel(p, new OpenOption[0]);
                continue;
            }
            error = true;
            break;
        }
        if (selectedpartition == null) {
            selectedpartition = TargetPartition.HEADER;
        }
        if (isEssenceDescriptorOnly == null) {
            isEssenceDescriptorOnly = false;
        }
        if (error || f == null || mds == null || p == null) {
            System.out.println(USAGE);
            return;
        }
        final LabelsRegister lr = labelreader != null ? LabelsRegister.fromXML(labelreader) : null;
        FragmentBuilder.AUIDNameResolver anr = null;
        if (lr != null) {
            anr = new FragmentBuilder.AUIDNameResolver(){

                @Override
                public String getLocalName(AUID enumid) {
                    LabelsRegister.Entry e = lr.getEntryByUL(enumid.asUL());
                    return e == null ? null : e.getSymbol();
                }
            };
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        doc.setXmlStandalone(true);
        UL root = isEssenceDescriptorOnly != false ? ESSENCE_DESCRIPTOR_KEY : PREFACE_KEY;
        DocumentFragment df = null;
        TargetPartition actualpartition = TargetPartition.AUTO.equals((Object)selectedpartition) ? TargetPartition.FOOTER : selectedpartition;
        boolean retry = true;
        while (retry) {
            try {
                switch (actualpartition) {
                    case FOOTER: {
                        if (MXFFiles.seekFooterPartition(f) >= 0L) break;
                        throw new Exception("Footer partition not found");
                    }
                    case HEADER: {
                        if (MXFFiles.seekHeaderPartition(f) >= 0L) break;
                        throw new Exception("Header partition not found");
                    }
                }
                InputStream is = Channels.newInputStream(f);
                df = MXFFragmentBuilder.fromInputStream(is, mds, anr, root, doc);
            }
            catch (Exception e) {
                if (TargetPartition.AUTO.equals((Object)selectedpartition)) {
                    actualpartition = TargetPartition.HEADER;
                    f.position(0L);
                    continue;
                }
                LOG.severe(e.getMessage());
                throw e;
            }
            finally {
                retry = false;
            }
        }
        Date now = new Date();
        doc.appendChild(doc.createComment("Created: " + now.toString()));
        doc.appendChild(doc.createComment("From: " + p.getFileName().toString()));
        doc.appendChild(doc.createComment("Partition: " + actualpartition.name()));
        doc.appendChild(doc.createComment("By: regxmllib build " + BuildVersionSingleton.getBuildVersion()));
        doc.appendChild(doc.createComment("See: https://github.com/sandflow/regxmllib"));
        doc.appendChild(df);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.transform(new DOMSource(doc), new StreamResult(System.out));
    }

    private static enum TargetPartition {
        HEADER,
        FOOTER,
        AUTO;

    }
}

