/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml;

import com.sandflow.smpte.klv.Group;
import com.sandflow.smpte.klv.KLVInputStream;
import com.sandflow.smpte.klv.LocalSet;
import com.sandflow.smpte.klv.LocalTagRegister;
import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.mxf.FillItem;
import com.sandflow.smpte.mxf.PartitionPack;
import com.sandflow.smpte.mxf.PrimerPack;
import com.sandflow.smpte.mxf.Set;
import com.sandflow.smpte.regxml.FragmentBuilder;
import com.sandflow.smpte.regxml.dict.DefinitionResolver;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.CountingInputStream;
import com.sandflow.smpte.util.UL;
import com.sandflow.smpte.util.UUID;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class MXFFragmentBuilder {
    private static final Logger LOG = Logger.getLogger(MXFFragmentBuilder.class.getName());
    private static final UL INDEX_TABLE_SEGMENT_UL = UL.fromURN("urn:smpte:ul:060e2b34.02530101.0d010201.01100100");
    private static final UL PREFACE_KEY = UL.fromURN("urn:smpte:ul:060e2b34.027f0101.0d010101.01012f00");

    public static DocumentFragment fromInputStream(InputStream mxfpartition, DefinitionResolver defresolver, UL rootclasskey, Document document) throws IOException, KLVException, MXFException, ParserConfigurationException, FragmentBuilder.RuleException {
        return MXFFragmentBuilder.fromInputStream(mxfpartition, defresolver, null, rootclasskey, document);
    }

    public static DocumentFragment fromInputStream(InputStream mxfpartition, DefinitionResolver defresolver, FragmentBuilder.AUIDNameResolver enumnameresolver, UL rootclasskey, Document document) throws IOException, KLVException, MXFException, ParserConfigurationException, FragmentBuilder.RuleException {
        Group agroup;
        Object t;
        Triplet t2;
        Triplet t3;
        CountingInputStream cis = new CountingInputStream(mxfpartition);
        KLVInputStream kis = new KLVInputStream(cis);
        PartitionPack pp = null;
        while ((t3 = kis.readTriplet()) != null && (pp = PartitionPack.fromTriplet(t3)) == null) {
        }
        if (pp == null) {
            throw new MXFException("No Partition Pack found.");
        }
        cis.resetCount();
        LocalTagRegister localreg = null;
        while ((t2 = kis.readTriplet()) != null) {
            if (!t2.getKey().equalsIgnoreVersion(FillItem.getKey())) {
                localreg = PrimerPack.createLocalTagRegister(t2);
                break;
            }
            cis.resetCount();
        }
        if (localreg == null) {
            System.err.println("No Primer Pack found");
        }
        ArrayList<LocalSet> gs = new ArrayList<LocalSet>();
        HashMap<UUID, Set> setresolver = new HashMap<UUID, Set>();
        while (cis.getCount() < pp.getHeaderByteCount() && (t = kis.readTriplet()) != null) {
            if (t.getKey().equalsIgnoreVersion(INDEX_TABLE_SEGMENT_UL)) {
                LOG.warning("Index Table Segment encountered before Header Byte Count bytes read.");
                break;
            }
            if (t.getKey().equalsIgnoreVersion(FillItem.getKey())) continue;
            try {
                LocalSet g = LocalSet.fromTriplet((Triplet)t, localreg);
                if (g != null) {
                    gs.add(g);
                    Set set = Set.fromGroup(g);
                    if (set == null) continue;
                    setresolver.put(set.getInstanceID(), set);
                    continue;
                }
                LOG.log(Level.WARNING, "Failed to read Group: {0}", t.getKey().toString());
            }
            catch (KLVException ke) {
                LOG.warning(String.format("Failed to read Group %s with error %s", t.getKey().toString(), ke.getMessage()));
            }
        }
        t = gs.iterator();
        while (t.hasNext() && !(agroup = (Group)t.next()).getKey().equalsWithMask(PREFACE_KEY, 64255)) {
            if (agroup.getKey().isClass14()) continue;
            LOG.warning(String.format("Invalid MXF file: at least one non-class 14 Set %s was found between the Primer Pack and the Preface Set.", agroup.getKey()));
            break;
        }
        FragmentBuilder fb = new FragmentBuilder(defresolver, setresolver, enumnameresolver);
        Group rootgroup = null;
        if (rootclasskey != null) {
            Iterator iter = gs.iterator();
            while (rootgroup == null && iter.hasNext()) {
                Definition def;
                Group g = (Group)iter.next();
                AUID gid = new AUID(g.getKey());
                while (rootgroup == null && gid != null && (def = defresolver.getDefinition(gid)) instanceof ClassDefinition) {
                    UL gul = def.getIdentification().asUL();
                    if (gul.equalsWithMask(rootclasskey, 64255)) {
                        rootgroup = g;
                        continue;
                    }
                    gid = ((ClassDefinition)def).getParentClass();
                }
            }
        } else {
            rootgroup = (Group)gs.get(0);
        }
        if (rootgroup == null) {
            throw new MXFException("Root object not found");
        }
        return fb.fromTriplet(rootgroup, document);
    }

    public static class MXFException
    extends Exception {
        public MXFException(String msg) {
            super(msg);
        }
    }
}

