/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.register;

import com.sandflow.smpte.register.QualifiedSymbol;
import com.sandflow.smpte.register.TypeEntry;
import com.sandflow.smpte.register.exceptions.DuplicateEntryException;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="TypesRegister", namespace="http://www.smpte-ra.org/schemas/2003/2012")
@XmlType(name="")
@XmlSeeAlso(value={TypeEntry.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public class TypesRegister {
    public static final String XML_NAMESPACE = "http://www.smpte-ra.org/schemas/2003/2012";
    private final HashMap<QualifiedSymbol, TypeEntry> entriesBySymbol = new HashMap();
    private final HashMap<UL, TypeEntry> entriesByUL = new HashMap();
    @XmlElement(name="Entry", namespace="http://www.smpte-ra.org/schemas/2003/2012")
    @XmlElementWrapper(name="Entries", namespace="http://www.smpte-ra.org/schemas/2003/2012")
    private final ArrayList<TypeEntry> entries = new ArrayList();

    public TypeEntry getEntryByUL(UL ul) {
        return this.entriesByUL.get(ul);
    }

    public TypeEntry getEntryBySymbol(String symbol, URI namespace) {
        return this.entriesBySymbol.get(new QualifiedSymbol(symbol, namespace));
    }

    public void addEntry(TypeEntry entry) throws DuplicateEntryException {
        QualifiedSymbol sym = new QualifiedSymbol(entry.getSymbol(), entry.getNamespaceName());
        if (this.entriesByUL.containsKey(entry.getUL())) {
            throw new DuplicateEntryException(String.format("UL = %s is already present (symbol = %s).", entry.getUL(), entry.getSymbol()));
        }
        if (this.entriesBySymbol.containsKey(sym)) {
            throw new DuplicateEntryException(String.format("Symbol = %s  is already present (UL = %s).", entry.getSymbol(), entry.getUL()));
        }
        this.entries.add(entry);
        this.entriesByUL.put(entry.getUL(), entry);
        this.entriesBySymbol.put(sym, entry);
    }

    public Collection<TypeEntry> getEntries() {
        return this.entries;
    }

    public void toXML(Writer writer) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TypesRegister.class});
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this, writer);
        writer.close();
    }

    public static TypesRegister fromXML(Reader reader) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TypesRegister.class});
        Unmarshaller m = ctx.createUnmarshaller();
        TypesRegister reg = (TypesRegister)m.unmarshal(reader);
        for (TypeEntry te : reg.entries) {
            QualifiedSymbol sym = new QualifiedSymbol(te.getSymbol(), te.getNamespaceName());
            reg.entriesByUL.put(te.getUL(), te);
            reg.entriesBySymbol.put(sym, te);
        }
        return reg;
    }
}

