/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.klv;

import com.sandflow.smpte.klv.MemoryTriplet;
import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.util.UL;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class KLVInputStream
extends DataInputStream {
    public KLVInputStream(InputStream is) {
        super(is);
    }

    public UL readUL() throws IOException, EOFException {
        byte[] ul = new byte[16];
        if (this.read(ul) < ul.length) {
            throw new EOFException();
        }
        return new UL(ul);
    }

    public long readBERLength() throws EOFException, IOException, KLVException {
        long val = 0L;
        int b = this.read();
        if (b <= 0) {
            throw new EOFException();
        }
        if ((b & 0x80) == 0) {
            return b;
        }
        int bersz = b & 0xF;
        if (bersz > 8) {
            throw new KLVException(KLVException.MAX_LENGTH_EXCEEED);
        }
        byte[] octets = new byte[bersz];
        if (this.read(octets) < bersz) {
            throw new EOFException();
        }
        for (int i = 0; i < bersz; ++i) {
            int tmp = octets[i] & 0xFF;
            if ((val = (val << 8) + (long)tmp) <= Integer.MAX_VALUE) continue;
            throw new KLVException(KLVException.MAX_LENGTH_EXCEEED);
        }
        return val;
    }

    public Triplet readTriplet() throws IOException, EOFException, KLVException {
        UL ul = this.readUL();
        long len = this.readBERLength();
        if (len > Integer.MAX_VALUE) {
            throw new KLVException(KLVException.MAX_LENGTH_EXCEEED);
        }
        byte[] value = new byte[(int)len];
        if (len != (long)this.read(value)) {
            throw new EOFException("EOF reached while reading Value.");
        }
        return new MemoryTriplet(ul, value);
    }

    public long readUnsignedInt() throws IOException, EOFException {
        return (long)this.readInt() & 0xFFFFL;
    }
}

