/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.MustacheException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    protected final Segment[] _segs;
    protected final Mustache.Compiler _compiler;
    protected final Map<Key, VariableFetcher> _fcache = new ConcurrentHashMap<Key, VariableFetcher>();
    protected static final VariableFetcher MAP_FETCHER = new VariableFetcher(){

        public Object get(Object ctx, String name) throws Exception {
            return ((Map)ctx).get(name);
        }
    };
    protected static final VariableFetcher THIS_FETCHER = new VariableFetcher(){

        public Object get(Object ctx, String name) throws Exception {
            return ctx;
        }
    };
    protected static final String DOT_NAME = ".".intern();
    protected static final String THIS_NAME = "this".intern();
    protected static final String FIRST_NAME = "-first".intern();
    protected static final String LAST_NAME = "-last".intern();
    protected static final String INDEX_NAME = "-index".intern();

    public void execute(Object context, Writer out) throws MustacheException {
        Context ctx = new Context(context, null, 0, Mode.OTHER);
        for (Segment seg : this._segs) {
            seg.execute(this, ctx, out);
        }
    }

    public String execute(Object context) throws MustacheException {
        StringWriter out = new StringWriter();
        this.execute(context, out);
        return out.toString();
    }

    protected Template(Segment[] segs, Mustache.Compiler compiler) {
        this._segs = segs;
        this._compiler = compiler;
    }

    protected Object getValue(Context ctx, String name, int line) {
        if (!this._compiler.standardsMode && name != DOT_NAME && name.indexOf(DOT_NAME) != -1) {
            String[] comps = name.split("\\.");
            Object data = this.getValue(ctx, comps[0].intern(), line);
            for (int ii = 1; ii < comps.length; ++ii) {
                if (data == null) {
                    throw new NullPointerException("Null context for compound variable '" + name + "' on line " + line + ". '" + comps[ii - 1] + "' resolved to null.");
                }
                data = this.getValueIn(data, comps[ii].intern(), line);
            }
            return data;
        }
        if (name == FIRST_NAME) {
            return ctx.mode == Mode.FIRST;
        }
        if (name == LAST_NAME) {
            return ctx.mode == Mode.LAST;
        }
        if (name == INDEX_NAME) {
            return ctx.index;
        }
        if (this._compiler.standardsMode) {
            return this.getValueIn(ctx.data, name, line);
        }
        while (ctx != null) {
            Object value = this.getValueIn(ctx.data, name, line);
            if (value != null) {
                return value;
            }
            ctx = ctx.parent;
        }
        return null;
    }

    protected Object getValueIn(Object data, String name, int line) {
        if (data == null) {
            throw new NullPointerException("Null context for variable '" + name + "' on line " + line);
        }
        Key key = new Key(data.getClass(), name);
        VariableFetcher fetcher = this._fcache.get(key);
        if (fetcher != null) {
            try {
                return fetcher.get(data, name);
            }
            catch (Exception e) {
                fetcher = Template.createFetcher(key);
            }
        } else {
            fetcher = Template.createFetcher(key);
        }
        if (fetcher == null) {
            return null;
        }
        try {
            Object value = fetcher.get(data, name);
            this._fcache.put(key, fetcher);
            return value;
        }
        catch (Exception e) {
            throw new MustacheException("Failure fetching variable '" + name + "' on line " + line, e);
        }
    }

    protected static VariableFetcher createFetcher(Key key) {
        if (key.name == DOT_NAME || key.name == THIS_NAME) {
            return THIS_FETCHER;
        }
        if (Map.class.isAssignableFrom(key.cclass)) {
            return MAP_FETCHER;
        }
        final Method m = Template.getMethod(key.cclass, key.name);
        if (m != null) {
            return new VariableFetcher(){

                public Object get(Object ctx, String name) throws Exception {
                    return m.invoke(ctx, new Object[0]);
                }
            };
        }
        final Field f = Template.getField(key.cclass, key.name);
        if (f != null) {
            return new VariableFetcher(){

                public Object get(Object ctx, String name) throws Exception {
                    return f.get(ctx);
                }
            };
        }
        return null;
    }

    protected static Method getMethod(Class<?> clazz, String name) {
        Method m;
        try {
            m = clazz.getDeclaredMethod(name, new Class[0]);
            if (!m.getReturnType().equals(Void.TYPE)) {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            m = clazz.getDeclaredMethod("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]);
            if (!m.getReturnType().equals(Void.TYPE)) {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Class<?> sclass = clazz.getSuperclass();
        if (sclass != Object.class && sclass != null) {
            return Template.getMethod(clazz.getSuperclass(), name);
        }
        return null;
    }

    protected static Field getField(Class<?> clazz, String name) {
        try {
            Field f = clazz.getDeclaredField(name);
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            return f;
        }
        catch (Exception e) {
            Class<?> sclass = clazz.getSuperclass();
            if (sclass != Object.class && sclass != null) {
                return Template.getField(clazz.getSuperclass(), name);
            }
            return null;
        }
    }

    protected static abstract class VariableFetcher {
        protected VariableFetcher() {
        }

        abstract Object get(Object var1, String var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Key {
        public final Class<?> cclass;
        public final String name;

        public Key(Class<?> cclass, String name) {
            this.cclass = cclass;
            this.name = name;
        }

        public int hashCode() {
            return this.cclass.hashCode() * 31 + this.name.hashCode();
        }

        public boolean equals(Object other) {
            Key okey = (Key)other;
            return okey.cclass == this.cclass && okey.name == this.name;
        }
    }

    protected static abstract class Segment {
        protected Segment() {
        }

        abstract void execute(Template var1, Context var2, Writer var3);

        protected static void write(Writer out, String data) {
            try {
                out.write(data);
            }
            catch (IOException ioe) {
                throw new MustacheException(ioe);
            }
        }
    }

    protected static class Context {
        public final Object data;
        public final Context parent;
        public final int index;
        public final Mode mode;

        public Context(Object data, Context parent, int index, Mode mode) {
            this.data = data;
            this.parent = parent;
            this.index = index;
            this.mode = mode;
        }

        public Context nest(Object data, int index, Mode mode) {
            return new Context(data, this, index, mode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Mode {
        FIRST,
        OTHER,
        LAST;

    }
}

