/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.servlet;

import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.NotifierException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class SamebugFilter
implements Filter {
    private SamebugNotifier notifier;

    public void init(FilterConfig config) throws ServletException {
        String applicationKey = config.getInitParameter("samebug.key");
        this.notifier = applicationKey != null ? new SamebugNotifier(applicationKey) : new SamebugNotifier();
    }

    private void notify(ServletRequest request, Throwable e) throws NotifierException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hr = (HttpServletRequest)request;
            StringBuffer url = hr.getRequestURL();
            String qs = hr.getQueryString();
            StringBuilder sb = new StringBuilder();
            sb.append("Unhandled exception at ").append(url).append(" : ");
            if (qs != null) {
                sb.append("?").append(qs);
            }
            this.notifier.notify(sb.toString(), e);
        } else {
            this.notifier.notify("Unhandled exception", e);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block7: {
            try {
                try {
                    chain.doFilter(request, response);
                }
                catch (IOException e) {
                    this.notify(request, e);
                    throw e;
                }
                catch (ServletException e) {
                    this.notify(request, e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.notify(request, e);
                    throw e;
                }
                catch (Error e) {
                    this.notify(request, e);
                    throw e;
                }
            }
            catch (NotifierException e) {
                if (!this.notifier.getConfiguration().getDebug()) break block7;
                e.printStackTrace(System.err);
            }
        }
    }
}

