/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.proxy;

import com.samebug.notifier.proxy.StackTraceProxy;

public class DefaultStackTraceProxy
implements StackTraceProxy {
    private final StackTraceElement[] trace;

    public DefaultStackTraceProxy(StackTraceElement[] stackTrace) {
        this.trace = stackTrace;
    }

    public String[] getFrames() {
        String[] frames = new String[this.trace.length];
        for (int i = 0; i < this.trace.length; ++i) {
            frames[i] = this.trace[i].toString();
        }
        return frames;
    }

    public int getCommonFrames(DefaultStackTraceProxy other) {
        if (other == null) {
            return 0;
        }
        int m = this.trace.length - 1;
        for (int n = other.trace.length - 1; m >= 0 && n >= 0 && this.trace[m].equals(other.trace[n]); --m, --n) {
        }
        return this.trace.length - 1 - m;
    }

    public int getCommonFrames(StackTraceProxy other) {
        if (other == null) {
            return 0;
        }
        if (other instanceof DefaultStackTraceProxy) {
            return this.getCommonFrames((DefaultStackTraceProxy)other);
        }
        String[] thisFrames = this.getFrames();
        String[] otherFrames = other.getFrames();
        int m = thisFrames.length - 1;
        for (int n = otherFrames.length - 1; m >= 0 && n >= 0 && thisFrames[m].equals(otherFrames[n]); --m, --n) {
        }
        return thisFrames.length - 1 - m;
    }
}

