/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.Configuration;
import com.samebug.notifier.INotifier;
import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.SamebugUncaughtExceptionHandler;
import com.samebug.notifier.exceptions.BadAppKey;
import com.samebug.notifier.exceptions.BadServerAddress;
import com.samebug.notifier.exceptions.MultipleConfigFileException;
import com.samebug.notifier.exceptions.NoConfigFileException;
import com.samebug.notifier.exceptions.NotifierException;
import com.samebug.notifier.proxy.ThrowableProxy;
import java.util.Date;
import java.util.UUID;

public class Samebug {
    private static boolean initialized = false;
    private static INotifier notifier;

    public static void handleUncaughtExceptions() throws NoConfigFileException, MultipleConfigFileException, BadAppKey, BadServerAddress {
        SamebugUncaughtExceptionHandler handler = new SamebugUncaughtExceptionHandler();
        Samebug.installHandler(handler);
    }

    public static void handleUncaughtExceptions(String applicationKey) throws BadAppKey {
        SamebugUncaughtExceptionHandler handler = new SamebugUncaughtExceptionHandler(applicationKey);
        Samebug.installHandler(handler);
    }

    public static void handleUncaughtExceptions(Configuration config) throws BadAppKey, BadServerAddress {
        SamebugUncaughtExceptionHandler handler = new SamebugUncaughtExceptionHandler(config);
        Samebug.installHandler(handler);
    }

    private static void installHandler(Thread.UncaughtExceptionHandler handler) {
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public static synchronized void init() throws NoConfigFileException, MultipleConfigFileException, BadAppKey, BadServerAddress {
        if (!initialized) {
            notifier = new SamebugNotifier();
            initialized = true;
        }
    }

    public static synchronized void init(String applicationKey) throws BadAppKey {
        if (!initialized) {
            notifier = new SamebugNotifier(applicationKey);
            initialized = true;
        }
    }

    public static synchronized void init(Configuration config) throws BadAppKey, BadServerAddress {
        if (!initialized) {
            notifier = new SamebugNotifier(config);
            initialized = true;
        }
    }

    public static UUID notify(String message, Throwable throwable) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwable);
    }

    public static UUID notify(String message, Throwable throwable, Date timestamp) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwable, timestamp);
    }

    public static UUID notify(String message, ThrowableProxy throwableProxy) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwableProxy);
    }

    public static UUID notify(String message, ThrowableProxy throwableProxy, Date timestamp) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwableProxy, timestamp);
    }
}

