/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.Configuration;
import com.samebug.notifier.exceptions.AccountExpired;
import com.samebug.notifier.exceptions.AccountLimitExceeded;
import com.samebug.notifier.exceptions.BadRequest;
import com.samebug.notifier.exceptions.ConnectionError;
import com.samebug.notifier.exceptions.ConnectionTimeout;
import com.samebug.notifier.exceptions.NoResponse;
import com.samebug.notifier.exceptions.NoURI;
import com.samebug.notifier.exceptions.ReadError;
import com.samebug.notifier.exceptions.RecorderError;
import com.samebug.notifier.exceptions.RequestTooLarge;
import com.samebug.notifier.exceptions.UnknownProtocol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.util.UUID;

class Connection {
    private static final String USER_AGENT = "Samebug-Notifier-Java/1.0.0";
    private final Configuration config;

    public Connection(Configuration config) {
        this.config = config;
    }

    public HttpURLConnection createConnection() {
        try {
            URLConnection urlConnection = this.config.getServerURL().openConnection();
            if (urlConnection == null || !(urlConnection instanceof HttpURLConnection)) {
                throw new UnknownProtocol("Cannot connect to " + this.config.getServerURL());
            }
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(5000);
            connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "text/plain");
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("X-Samebug-Key", this.config.getAppKey().toString());
            connection.setDoOutput(true);
            connection.connect();
            return connection;
        }
        catch (SocketTimeoutException e) {
            throw new ConnectionTimeout("Cannot connect to " + this.config.getServerURL(), e);
        }
        catch (IOException e) {
            throw new ConnectionError("IO error while opening connection to " + this.config.getServerURL(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID processResponse(HttpURLConnection conn) throws RecorderError, NoResponse, NoURI, ReadError {
        try {
            BufferedReader rd;
            int rc = conn.getResponseCode();
            String rm = conn.getResponseMessage();
            switch (rc) {
                case 200: {
                    rd = null;
                    rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    String line = rd.readLine();
                    if (line != null) {
                        UUID uUID = UUID.fromString(line);
                        return uUID;
                    }
                    throw new NoURI("No report URI.");
                }
                case 400: {
                    throw new BadRequest("Samebug rejected your request. Are you sure your application key is " + this.config.getAppKey() + " ?");
                }
                case 403: {
                    throw new AccountExpired("You are not authorized to send notifications here. Probably your account is expired!");
                }
                case 413: {
                    throw new RequestTooLarge("Samebug rejected your request. The sent crash log is too large.");
                }
                case 429: {
                    throw new AccountLimitExceeded("Samebug rejected your request. You have sent too many requests from this account. You should enhance your account.");
                }
                case 500: {
                    throw new RecorderError(rc, rm);
                }
            }
            throw new RecorderError(rc, "Unexpected response:\n" + rm);
            catch (SocketTimeoutException e) {
                throw new ReadError("Timeout read from " + this.config.getServerURL(), e);
            }
            catch (IOException e) {
                throw new ReadError("Unable to read response from " + this.config.getServerURL(), e);
            }
            finally {
                block24: {
                    if (rd != null) {
                        try {
                            rd.close();
                        }
                        catch (IOException e) {
                            if (!this.config.getDebug()) break block24;
                            System.err.println("Samebug: Error while closing connection stream:");
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            throw new ConnectionTimeout("Timeout while waiting response from " + this.config.getServerURL(), e);
        }
        catch (IOException e) {
            throw new NoResponse("Unable to process response from " + this.config.getServerURL(), e);
        }
    }
}

