/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.exceptions.BadAppKey;
import com.samebug.notifier.exceptions.BadConfigFile;
import com.samebug.notifier.exceptions.BadServerAddress;
import com.samebug.notifier.exceptions.MultipleConfigFileException;
import com.samebug.notifier.exceptions.NoConfigFileException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class Configuration {
    private static final String DEFAULT_PROPERTY_RESOURCE = "samebug.properties";
    private static final String DEFAULT_SERVER = "http://recorder.samebug.io";
    private static final String DEFAULT_DEBUG = "false";
    private UUID appKey;
    private String version;
    private URL serverURL;
    private boolean debug;

    public Configuration(String appKey) throws BadAppKey {
        this.setAppKey(appKey);
    }

    private Configuration(String appKey, String version, String serverAddress, String debug) throws BadAppKey, BadServerAddress {
        this.setAppKey(appKey);
        this.setVersion(version);
        this.setServer(serverAddress);
        this.setDebug(debug);
    }

    private void setAppKey(String appKey) throws BadAppKey {
        if (appKey == null) {
            throw new BadAppKey("Application key is missing!");
        }
        try {
            this.appKey = UUID.fromString(appKey);
        }
        catch (IllegalArgumentException e) {
            throw new BadAppKey(appKey + " is not parsable as application key");
        }
        assert (this.appKey != null);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setServer(String serverAddress) throws BadServerAddress {
        if (serverAddress == null) {
            throw new BadServerAddress("Server address must not be null.");
        }
        try {
            this.serverURL = new URI(serverAddress).toURL();
        }
        catch (URISyntaxException e) {
            throw new BadServerAddress(serverAddress + " is not a valid URI");
        }
        catch (MalformedURLException e) {
            throw new BadServerAddress(serverAddress + " is not a valid URL");
        }
        assert (this.serverURL != null);
    }

    public void setDebug(String debug) {
        this.debug = debug != DEFAULT_DEBUG;
    }

    public UUID getAppKey() {
        return this.appKey;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getServerURL() {
        return this.serverURL;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public static Configuration fromProperties() throws NoConfigFileException, MultipleConfigFileException, BadAppKey, BadServerAddress {
        String file;
        int specified = 0;
        String resource = System.getProperty("samebug.config.resource");
        if (resource != null) {
            ++specified;
        }
        if ((file = System.getProperty("samebug.config.file")) != null) {
            ++specified;
        }
        if (specified == 0) {
            return Configuration.fromDefault();
        }
        if (specified > 1) {
            throw new MultipleConfigFileException("You specified more than one property file for samebug:\nconfig.file=" + file + "\nconfig.resource=" + resource);
        }
        if (resource != null) {
            return Configuration.fromPropertyResource(resource);
        }
        return Configuration.fromPropertyFile(file);
    }

    public static Configuration fromDefault() throws NoConfigFileException, MultipleConfigFileException, BadAppKey, BadServerAddress {
        try {
            Configuration.openResource(DEFAULT_PROPERTY_RESOURCE);
            return Configuration.fromPropertyResource(DEFAULT_PROPERTY_RESOURCE);
        }
        catch (Exception e) {
            return Configuration.fromProps(new Properties());
        }
    }

    public static Configuration fromPropertyResource(String resourceName) throws NoConfigFileException, MultipleConfigFileException, BadServerAddress, BadAppKey {
        Properties props = new Properties();
        InputStream propFile = null;
        try {
            propFile = Configuration.openResource(resourceName);
        }
        catch (IOException e) {
            throw new NoConfigFileException();
        }
        try {
            props.load(propFile);
        }
        catch (IOException e) {
            throw new BadConfigFile();
        }
        return Configuration.fromProps(props);
    }

    public static Configuration fromPropertyFile(String fileName) throws NoConfigFileException, MultipleConfigFileException, BadServerAddress, BadAppKey {
        FileInputStream propFile;
        Properties props = new Properties();
        try {
            propFile = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e1) {
            throw new NoConfigFileException();
        }
        try {
            props.load(propFile);
        }
        catch (IOException e) {
            throw new BadConfigFile();
        }
        return Configuration.fromProps(props);
    }

    private static Configuration fromProps(Properties props) {
        props.putAll((Map<?, ?>)System.getProperties());
        String appKey = props.getProperty("samebug.key");
        String version = props.getProperty("samebug.version");
        String serverAddress = props.getProperty("samebug.server", DEFAULT_SERVER);
        String debug = props.getProperty("samebug.debug", DEFAULT_DEBUG);
        return new Configuration(appKey, version, serverAddress, debug);
    }

    protected static InputStream openResource(String resourceName) throws NoConfigFileException, MultipleConfigFileException, IOException {
        Enumeration<URL> urls = Configuration.class.getClassLoader().getResources(resourceName);
        if (!urls.hasMoreElements()) {
            throw new NoConfigFileException("No configuration resource found with name " + resourceName);
        }
        URL onlyConfig = urls.nextElement();
        if (urls.hasMoreElements()) {
            throw new MultipleConfigFileException("Multiple configuration resource found in the classpath with name " + resourceName);
        }
        return onlyConfig.openStream();
    }
}

