/*
 * Created on 2013.09.03.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.proxy;

public class DefaultThrowableProxy implements ThrowableProxy {
    private final Throwable throwable;

    public String getClassName() {
        return this.throwable.getClass().getCanonicalName();
    }

    public String getMessage() {
        return this.throwable.getMessage();
    }

    public ThrowableProxy getCause() {
        return this.throwable.getCause() == null ? null : new DefaultThrowableProxy(this.throwable.getCause());
    }

    public StackTraceProxy getStackTrace() {
        return new DefaultStackTraceProxy(this.throwable.getStackTrace());
    }

    public DefaultThrowableProxy(final Throwable throwable) {
        this.throwable = throwable;
    }

    public int getCommonFramesWithCause() {
        if (getCause() == null) {
            return 0;
        } else {
            return ((DefaultStackTraceProxy) getStackTrace()).getCommonFrames(getCause().getStackTrace());
        }
    }
}
