/*
 * Created on 2013.09.02.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.log4j;

import java.util.Date;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.NotifierException;

public class SamebugAppender extends AppenderSkeleton {
    private final SamebugNotifier notifier;

    public SamebugAppender() {
        super();
        notifier = new SamebugNotifier();
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    @Override
    protected void append(final LoggingEvent event) {
        if (event.getThrowableInformation() != null) {
            try {
                notifier.notify(event.getMessage() == null ? null : String.valueOf(event.getMessage()), event.getThrowableInformation().getThrowable(), new Date());
            } catch (final NotifierException e) {
                System.err.println("Error in samebug notifier (code " + e.getErrorCode() + "): " + e.getMessage());
                if (notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
            } catch (final RuntimeException e) {
                if (notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
                throw e;
            }
        }
    }
}
