/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.encoder;

import com.samebug.notifier.exceptions.JsonEncodingException;
import com.samebug.notifier.proxy.StackTraceProxy;
import com.samebug.notifier.proxy.ThrowableProxy;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ContentEncoder {
    private final Writer writer;
    private static final DateFormat F_XSD_DATE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private boolean first;

    public ContentEncoder(Writer writer) {
        this.writer = writer;
        this.first = true;
    }

    public void startObject() throws JsonEncodingException {
        this.write("{");
    }

    public void endObject() throws JsonEncodingException {
        this.write("}");
    }

    public void writeField(String name, String value) throws JsonEncodingException {
        if (value == null) {
            return;
        }
        this.nextField();
        this.fieldName(name);
        this.fieldValue(value);
    }

    public void writeField(String name, Date value) throws JsonEncodingException {
        if (value == null) {
            return;
        }
        this.nextField();
        this.fieldName(name);
        this.fieldValue(F_XSD_DATE.format(value));
    }

    public void writeField(String name, ThrowableProxy value) throws JsonEncodingException {
        if (value == null) {
            return;
        }
        this.nextField();
        this.fieldName(name);
        this.fieldValue(value);
    }

    public void writeField(String name, int value) throws JsonEncodingException {
        this.nextField();
        this.fieldName(name);
        this.encode(value);
    }

    private void fieldValue(String value) throws JsonEncodingException {
        this.write('\"');
        this.encode(value);
        this.write('\"');
    }

    private void fieldValue(ThrowableProxy value) throws JsonEncodingException {
        new ContentEncoder(this.writer).encode(value);
    }

    private void encode(int value) throws JsonEncodingException {
        this.write(value);
    }

    public void encode(ThrowableProxy t) throws JsonEncodingException {
        this.encode(t, 0);
    }

    private void fieldName(String name) throws JsonEncodingException {
        this.write('\"');
        this.encode(name);
        this.write('\"');
        this.write(':');
    }

    private void nextField() throws JsonEncodingException {
        if (this.first) {
            this.first = false;
        } else {
            this.write(',');
        }
    }

    private void encode(String s) throws JsonEncodingException {
        int len = s.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    this.write("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.write("\\\\");
                    continue block10;
                }
                case '\b': {
                    this.write("\\b");
                    continue block10;
                }
                case '\f': {
                    this.write("\\f");
                    continue block10;
                }
                case '\n': {
                    this.write("\\n");
                    continue block10;
                }
                case '\r': {
                    this.write("\\r");
                    continue block10;
                }
                case '\t': {
                    this.write("\\t");
                    continue block10;
                }
                case '/': {
                    this.write("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        this.write("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            this.write('0');
                        }
                        this.write(ss.toUpperCase());
                        continue block10;
                    }
                    this.write(ch);
                }
            }
        }
    }

    private void encode(ThrowableProxy throwable, int commonFrames) throws JsonEncodingException {
        this.write('{');
        this.writeField("class", throwable.getClassName());
        if (throwable.getMessage() != null) {
            this.writeField("message", throwable.getMessage());
        }
        if (commonFrames > 0) {
            this.writeField("more", commonFrames);
        }
        this.nextField();
        this.fieldName("trace");
        this.encode(throwable.getStackTrace(), commonFrames);
        ThrowableProxy cause = throwable.getCause();
        if (cause != null) {
            this.nextField();
            this.fieldName("cause");
            new ContentEncoder(this.writer).encode(cause, throwable.getCommonFramesWithCause());
        }
        this.write('}');
    }

    private void encode(StackTraceProxy trace, int commonFrames) throws JsonEncodingException {
        this.write('\"');
        String[] frames = trace.getFrames();
        int m = frames.length - 1 - commonFrames;
        for (int i = 0; i < m; ++i) {
            this.encode(frames[i]);
            this.write("\\n");
        }
        this.encode(frames[m]);
        this.write('\"');
    }

    private void write(char ch) throws JsonEncodingException {
        try {
            this.writer.write(ch);
        }
        catch (IOException e) {
            throw new JsonEncodingException("Unable to write char " + ch, e);
        }
    }

    private void write(int i) throws JsonEncodingException {
        this.write(String.valueOf(i));
    }

    private void write(String s) throws JsonEncodingException {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new JsonEncodingException("Unable to write string " + s, e);
        }
    }
}

