/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.INotifier;
import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.SamebugUncaughtExceptionHandler;
import com.samebug.notifier.exceptions.NotifierException;
import com.samebug.notifier.proxy.ThrowableProxy;
import java.util.Date;
import java.util.UUID;

public class Samebug {
    private static boolean initialized = false;
    private static INotifier notifier;

    public static void handleUncaughtExceptions() {
        SamebugUncaughtExceptionHandler handler = new SamebugUncaughtExceptionHandler();
        Samebug.installHandler(handler);
    }

    public static void handleUncaughtExceptions(String applicationKey) {
        SamebugUncaughtExceptionHandler handler = new SamebugUncaughtExceptionHandler(applicationKey);
        Samebug.installHandler(handler);
    }

    private static void installHandler(Thread.UncaughtExceptionHandler handler) {
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public static synchronized void init() {
        if (!initialized) {
            notifier = new SamebugNotifier();
            initialized = true;
        }
    }

    public static synchronized void init(String applicationKey) {
        if (!initialized) {
            notifier = new SamebugNotifier(applicationKey);
            initialized = true;
        }
    }

    public static UUID notify(String message, Throwable throwable) throws NotifierException {
        if (!initialized) {
            throw new IllegalArgumentException("Samebug not initialized");
        }
        return notifier.notify(message, throwable);
    }

    public static UUID notify(String message, Throwable throwable, Date timestamp) throws NotifierException {
        if (!initialized) {
            throw new IllegalArgumentException("Samebug not initialized");
        }
        return notifier.notify(message, throwable, timestamp);
    }

    public static UUID notify(String message, ThrowableProxy throwableProxy) throws NotifierException {
        if (!initialized) {
            throw new IllegalArgumentException("Samebug not initialized");
        }
        return notifier.notify(message, throwableProxy);
    }

    public static UUID notify(String message, ThrowableProxy throwableProxy, Date timestamp) throws NotifierException {
        if (!initialized) {
            throw new IllegalArgumentException("Samebug not initialized");
        }
        return notifier.notify(message, throwableProxy, timestamp);
    }
}

