/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.INotifier;
import com.samebug.notifier.exceptions.ConnectionError;
import com.samebug.notifier.exceptions.MultipleConfigFileException;
import com.samebug.notifier.exceptions.NoConfigFileException;
import com.samebug.notifier.exceptions.UnknownProtocol;
import com.samebug.notifier.exceptions.UrlEncodingError;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractNotifier
implements INotifier {
    protected static final String SAMEBUG_VERSION = "1.0.1";
    protected static final String SAMEBUG_PLATFORM = "Java";
    private static final String DEFAULT_PROPERTY_FILE = "samebug.properties";
    private static final String DEFAULT_CONNECTION_TIMEOUT = "1000";
    private static final String DEFAULT_READ_TIMEOUT = "1000";
    private static final String DEFAULT_SERVER = "http://recorder.samebug.io";
    protected int connectionTimeout;
    protected String key;
    protected URL notificationUrl;
    protected int readTimeout;
    protected String server;
    protected String version;
    protected Proxy proxy;

    public AbstractNotifier() {
        this.configureByProperties(DEFAULT_PROPERTY_FILE);
    }

    public AbstractNotifier(String applicationKey) {
        this.key = applicationKey;
    }

    protected void configureByProperties(String propertyResourceFile) {
        Properties props = new Properties();
        try {
            InputStream propFile = this.openResource(propertyResourceFile);
            props.load(propFile);
        }
        catch (IOException ex) {
            System.err.println("Exception while reading samebug property file:\n" + ex);
            return;
        }
        catch (NoConfigFileException ex) {
            System.err.println("No samebug configuration file found on the classpath by name " + propertyResourceFile);
            return;
        }
        catch (MultipleConfigFileException ex) {
            System.err.println("Multiple samebug configuration file found on the classpath by name " + propertyResourceFile);
            return;
        }
        props.putAll((Map<?, ?>)System.getProperties());
        String cto = props.getProperty("samebug.connectionTimeout", "1000");
        try {
            this.readTimeout = Integer.parseInt(cto, 10);
        }
        catch (NumberFormatException ex) {
            System.err.println("Wrong format in readTimeout entry in samebug property file: " + cto);
        }
        String appkey = props.getProperty("samebug.key");
        if (appkey != null) {
            this.key = appkey;
        } else {
            System.err.println("No application key defined in samebug property file");
        }
        String rto = props.getProperty("samebug.readTimeout", "1000");
        try {
            this.readTimeout = Integer.parseInt(rto, 10);
        }
        catch (NumberFormatException ex) {
            System.err.println("wrong format in readTimeout entry in samebug property file: " + rto);
        }
        this.server = props.getProperty("samebug.server", DEFAULT_SERVER);
        this.version = props.getProperty("samebug.version");
        String host = props.getProperty("samebug.proxy.host");
        String portStr = props.getProperty("samebug.proxy.port");
        int port = 0;
        if (portStr != null) {
            try {
                port = Integer.parseInt(rto, 10);
            }
            catch (NumberFormatException ex) {
                System.err.println("wrong format in proxy port entry in samebug property file: " + portStr);
            }
        }
        if (port > 0 && host != null) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
    }

    protected HttpURLConnection createConnection() throws UrlEncodingError {
        try {
            URL serverUrl = new URI(this.server).toURL();
            URLConnection urlConnection = this.proxy == null ? serverUrl.openConnection() : serverUrl.openConnection(this.proxy);
            if (urlConnection == null || !(urlConnection instanceof HttpURLConnection)) {
                throw new UnknownProtocol("Cannot connect to " + this.server + ".");
            }
            return (HttpURLConnection)urlConnection;
        }
        catch (URISyntaxException ex) {
            throw new UrlEncodingError(ex);
        }
        catch (IOException e) {
            throw new ConnectionError("IO error while opening connection to " + this.server, e);
        }
    }

    protected InputStream openResource(String resourceName) throws NoConfigFileException, MultipleConfigFileException, IOException {
        Enumeration<URL> urls = this.getClass().getClassLoader().getResources(resourceName);
        if (!urls.hasMoreElements()) {
            throw new NoConfigFileException();
        }
        URL onlyConfig = urls.nextElement();
        if (urls.hasMoreElements()) {
            throw new MultipleConfigFileException();
        }
        return onlyConfig.openStream();
    }
}

