/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava.reflect;

import com.salesforce.servicelibs.com.github.mustachejava.Binding;
import com.salesforce.servicelibs.com.github.mustachejava.Code;
import com.salesforce.servicelibs.com.github.mustachejava.ObjectHandler;
import com.salesforce.servicelibs.com.github.mustachejava.TemplateContext;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.BaseObjectHandler;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.Guard;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.GuardedBinding;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.MissingWrapper;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.ReflectionWrapper;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.guards.ClassGuard;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.guards.DepthGuard;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.guards.DotGuard;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.guards.MapGuard;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.guards.NullGuard;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.guards.WrappedGuard;
import com.salesforce.servicelibs.com.github.mustachejava.util.GuardException;
import com.salesforce.servicelibs.com.github.mustachejava.util.Wrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReflectionObjectHandler
extends BaseObjectHandler {
    private static final Wrapper[] EMPTY_WRAPPERS = new Wrapper[0];
    private static final Guard[] EMPTY_GUARDS = new Guard[0];
    protected static final Method MAP_METHOD;

    public static Object unwrap(ObjectHandler oh, int scopeIndex, Wrapper[] wrappers, List<Object> scopes) throws GuardException {
        Object scope = oh.coerce(scopes.get(scopeIndex));
        if (wrappers != null) {
            for (Wrapper wrapper : wrappers) {
                scope = oh.coerce(wrapper.call(ObjectHandler.makeList(scope)));
            }
        }
        return scope;
    }

    @Override
    public Wrapper find(String name, List<Object> scopes) {
        Wrapper wrapper = null;
        int length = scopes.size();
        ArrayList<Guard> guards = new ArrayList<Guard>(length);
        guards.add(this.createDepthGuard(length));
        block2: for (int i = length - 1; i >= 0; --i) {
            Wrapper[] foundWrappers;
            int dotIndex;
            Object scope = scopes.get(i);
            if (scope == null) continue;
            guards.add(this.createClassGuard(i, scope));
            ArrayList<Wrapper> wrappers = null;
            String subname = name;
            wrapper = this.findWrapper(i, null, guards, scope, subname);
            if (wrapper != null) break;
            while ((dotIndex = subname.indexOf(46)) != -1) {
                String lookup = subname.substring(0, dotIndex);
                subname = subname.substring(dotIndex + 1);
                guards.add(this.createDotGuard(i, scope, lookup));
                ArrayList<Guard> wrapperGuard = new ArrayList<Guard>(1);
                wrapperGuard.add(this.createClassGuard(0, this.coerce(scope)));
                wrapper = this.findWrapper(0, null, wrapperGuard, scope, lookup);
                if (wrappers == null) {
                    wrappers = new ArrayList<Wrapper>();
                }
                if (wrapper != null) {
                    wrappers.add(wrapper);
                    try {
                        scope = this.coerce(wrapper.call(ObjectHandler.makeList(this.coerce(scope))));
                    }
                    catch (GuardException e) {
                        throw new AssertionError((Object)e);
                    }
                } else {
                    guards.add(this.createWrappedGuard(i, wrappers, wrapperGuard));
                    continue block2;
                }
                if (scope != null) continue;
                guards.add(this.createWrappedGuard(i, wrappers, Collections.singletonList(this.createNullGuard())));
                break;
            }
            if (wrappers != null) {
                guards.add(this.createWrappedGuard(i, (List<Wrapper>)wrappers, Collections.singletonList(new ClassGuard(0, scope))));
            }
            if ((wrapper = this.findWrapper(i, foundWrappers = wrappers == null ? null : wrappers.toArray(EMPTY_WRAPPERS), guards, scope, subname)) != null) break;
            if (wrappers == null) continue;
            wrapper = this.createMissingWrapper(subname, guards);
            break;
        }
        return wrapper == null ? this.createMissingWrapper(name, guards) : wrapper;
    }

    protected Wrapper findWrapper(int scopeIndex, Wrapper[] wrappers, List<Guard> guards, Object scope, String name) {
        AccessibleObject member;
        if ((scope = this.coerce(scope)) == null) {
            return null;
        }
        if (scope instanceof Map) {
            Map map = (Map)scope;
            if (map.containsKey(name)) {
                guards.add(this.createMapGuard(scopeIndex, wrappers, name, true));
                return this.createWrapper(scopeIndex, wrappers, guards, MAP_METHOD, new Object[]{name});
            }
            guards.add(this.createMapGuard(scopeIndex, wrappers, name, false));
            if (!this.areMethodsAccessible(map)) {
                return null;
            }
        }
        return (member = this.findMember(scope.getClass(), name)) == null ? null : this.createWrapper(scopeIndex, wrappers, guards, member, new Object[0]);
    }

    protected MissingWrapper createMissingWrapper(String name, List<Guard> guards) {
        return new MissingWrapper(name, guards.toArray(EMPTY_GUARDS));
    }

    protected DotGuard createDotGuard(int i, Object scope, String lookup) {
        return new DotGuard(lookup, i, scope);
    }

    protected WrappedGuard createWrappedGuard(int i, List<Wrapper> wrappers, List<Guard> wrapperGuard) {
        return new WrappedGuard(this, i, wrappers, wrapperGuard);
    }

    protected NullGuard createNullGuard() {
        return new NullGuard();
    }

    protected DepthGuard createDepthGuard(int length) {
        return new DepthGuard(length);
    }

    protected ClassGuard createClassGuard(int i, Object scope) {
        return new ClassGuard(i, scope);
    }

    protected MapGuard createMapGuard(int scopeIndex, Wrapper[] wrappers, String name, boolean contains) {
        return new MapGuard(this, scopeIndex, name, contains, wrappers);
    }

    protected Wrapper createWrapper(int scopeIndex, Wrapper[] wrappers, List<? extends Guard> guard, AccessibleObject member, Object[] arguments) {
        return new ReflectionWrapper(scopeIndex, wrappers, guard.toArray(EMPTY_GUARDS), member, arguments, this);
    }

    @Override
    public Binding createBinding(String name, TemplateContext tc, Code code) {
        return new GuardedBinding(this, name, tc, code);
    }

    protected boolean areMethodsAccessible(Map<?, ?> map) {
        return false;
    }

    static {
        try {
            MAP_METHOD = Map.class.getMethod("get", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

