/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.grpc.contrib.context.AmbientContext;
import com.salesforce.servicelibs.io.grpc.ForwardingServerCallListener;
import com.salesforce.servicelibs.io.grpc.Metadata;
import com.salesforce.servicelibs.io.grpc.ServerCall;
import com.salesforce.servicelibs.io.grpc.ServerCallHandler;
import com.salesforce.servicelibs.io.grpc.ServerInterceptor;

public class AmbientContextFreezeServerInterceptor
implements ServerInterceptor {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            public void onMessage(ReqT message) {
                this.freezeAndThaw(() -> super.onMessage(message));
            }

            public void onHalfClose() {
                this.freezeAndThaw(() -> super.onHalfClose());
            }

            public void onCancel() {
                this.freezeAndThaw(() -> super.onCancel());
            }

            public void onComplete() {
                this.freezeAndThaw(() -> super.onComplete());
            }

            public void onReady() {
                this.freezeAndThaw(() -> super.onReady());
            }

            private void freezeAndThaw(Runnable delegate) {
                if (AmbientContext.isPresent()) {
                    Object freezeKey = AmbientContext.current().freeze();
                    try {
                        delegate.run();
                    }
                    finally {
                        AmbientContext.current().thaw(freezeKey);
                    }
                } else {
                    delegate.run();
                }
            }
        };
    }
}

