/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import com.salesforce.servicelibs.com.google.common.base.Preconditions;
import com.salesforce.servicelibs.io.grpc.Server;
import java.util.concurrent.TimeUnit;

public final class Servers {
    public static Server shutdownGracefully(Server server, long maxWaitTimeInMillis) throws InterruptedException {
        return Servers.shutdownGracefully(server, maxWaitTimeInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server shutdownGracefully(Server server, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(server, "server");
        Preconditions.checkArgument(timeout > 0L, "timeout must be greater than 0");
        Preconditions.checkNotNull(unit, "unit");
        server.shutdown();
        try {
            server.awaitTermination(timeout, unit);
        }
        finally {
            server.shutdownNow();
        }
        return server;
    }

    public static Server shutdownWithJvm(Server server, long maxWaitTimeInMillis) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Servers.shutdownGracefully(server, maxWaitTimeInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
        return server;
    }

    private Servers() {
    }
}

