/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import com.salesforce.servicelibs.com.google.common.reflect.TypeToken;
import com.salesforce.servicelibs.com.google.gson.Gson;
import com.salesforce.servicelibs.com.google.protobuf.AbstractMessageLite;
import com.salesforce.servicelibs.com.google.protobuf.GeneratedMessageV3;
import com.salesforce.servicelibs.com.google.protobuf.InvalidProtocolBufferException;
import com.salesforce.servicelibs.io.grpc.Metadata;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class MoreMetadata {
    public static final Metadata.AsciiMarshaller<Boolean> BOOLEAN_MARSHALLER = new Metadata.AsciiMarshaller<Boolean>(){

        public String toAsciiString(Boolean value) {
            return value.toString();
        }

        public Boolean parseAsciiString(String serialized) {
            return Boolean.parseBoolean(serialized);
        }
    };
    public static final Metadata.AsciiMarshaller<Long> LONG_MARSHALLER = new Metadata.AsciiMarshaller<Long>(){

        public String toAsciiString(Long value) {
            return value.toString();
        }

        public Long parseAsciiString(String serialized) {
            return Long.parseLong(serialized);
        }
    };
    public static final Metadata.AsciiMarshaller<Double> DOUBLE_MARSHALLER = new Metadata.AsciiMarshaller<Double>(){

        public String toAsciiString(Double value) {
            return value.toString();
        }

        public Double parseAsciiString(String serialized) {
            return Double.parseDouble(serialized);
        }
    };

    private MoreMetadata() {
    }

    public static final <T> Metadata.AsciiMarshaller<T> JSON_MARSHALLER(final Class<T> clazz) {
        return new Metadata.AsciiMarshaller<T>(){
            TypeToken<T> typeToken;
            private Gson gson;
            {
                this.typeToken = TypeToken.of(clazz);
                this.gson = new Gson();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public String toAsciiString(T value) {
                try (StringWriter sw = new StringWriter();){
                    this.gson.toJson(value, this.typeToken.getType(), new UnicodeEscapingAsciiWriter(sw));
                    String string = sw.toString();
                    return string;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public T parseAsciiString(String serialized) {
                return this.gson.fromJson(serialized, this.typeToken.getType());
            }
        };
    }

    public static <T extends GeneratedMessageV3> Metadata.BinaryMarshaller<T> PROTOBUF_MARSHALLER(Class<T> clazz) {
        try {
            Method defaultInstance = clazz.getMethod("getDefaultInstance", new Class[0]);
            final GeneratedMessageV3 instance = (GeneratedMessageV3)defaultInstance.invoke(null, new Object[0]);
            return new Metadata.BinaryMarshaller<T>(){

                public byte[] toBytes(T value) {
                    return ((AbstractMessageLite)value).toByteArray();
                }

                public T parseBytes(byte[] serialized) {
                    try {
                        return instance.getParserForType().parseFrom(serialized);
                    }
                    catch (InvalidProtocolBufferException ipbe) {
                        throw new IllegalArgumentException(ipbe);
                    }
                }
            };
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static final class UnicodeEscapingAsciiWriter
    extends Writer {
        private final Writer out;

        private UnicodeEscapingAsciiWriter(Writer out) {
            this.out = out;
        }

        @Override
        public void write(char[] buffer, int offset, int count) throws IOException {
            for (int i = 0; i < count; ++i) {
                char c = buffer[i + offset];
                if (c >= ' ' && c <= '~') {
                    this.out.write(c);
                    continue;
                }
                this.out.write(String.format("\\u%04x", c));
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

