/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.interceptor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Arrays;
import java.util.List;

public class AggregateServerInterceptor
implements ServerInterceptor {
    private final List<ServerInterceptor> interceptors;

    public AggregateServerInterceptor(ServerInterceptor ... interceptors) {
        this(Arrays.asList((Object[])Preconditions.checkNotNull(interceptors, "interceptors")));
    }

    public AggregateServerInterceptor(List<ServerInterceptor> interceptors) {
        Preconditions.checkNotNull(interceptors, "interceptors");
        Preconditions.checkArgument(interceptors.size() > 0, "AggregateServerInterceptor requires at least one inner ServerInterceptor.");
        this.interceptors = interceptors;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        for (ServerInterceptor interceptor : Lists.reverse(this.interceptors)) {
            next = new InterceptorServerCallHandler(next, interceptor);
        }
        return next.startCall(call, headers);
    }

    private static final class InterceptorServerCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private final ServerCallHandler<ReqT, RespT> next;
        private final ServerInterceptor interceptor;

        private InterceptorServerCallHandler(ServerCallHandler<ReqT, RespT> next, ServerInterceptor interceptor) {
            this.next = next;
            this.interceptor = interceptor;
        }

        public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
            return this.interceptor.interceptCall(serverCall, metadata, this.next);
        }
    }
}

