/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh;

import java.util.concurrent.CountDownLatch;
import org.openjdk.jmh.infra.Blackhole;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class PerfSubscriber
implements Subscriber<Object> {
    private final Blackhole bh;
    protected final CountDownLatch latch;
    private Subscription subscription;

    public PerfSubscriber(Blackhole bh) {
        this.bh = bh;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(Object item) {
        this.bh.consume(item);
        this.subscription.request(1L);
    }

    @Override
    public void onError(Throwable throwable) {
        throwable.printStackTrace();
        this.bh.consume(throwable);
        this.latch.countDown();
    }

    @Override
    public void onComplete() {
        this.latch.countDown();
    }
}

