/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class FluxDistinct<T, K, C>
extends FluxOperator<T, T> {
    final Function<? super T, ? extends K> keyExtractor;
    final Supplier<C> collectionSupplier;
    final BiPredicate<C, K> distinctPredicate;
    final Consumer<C> cleanupCallback;

    FluxDistinct(Flux<? extends T> source, Function<? super T, ? extends K> keyExtractor, Supplier<C> collectionSupplier, BiPredicate<C, K> distinctPredicate, Consumer<C> cleanupCallback) {
        super(source);
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier, "collectionSupplier");
        this.distinctPredicate = Objects.requireNonNull(distinctPredicate, "distinctPredicate");
        this.cleanupCallback = Objects.requireNonNull(cleanupCallback, "cleanupCallback");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        C collection;
        try {
            collection = Objects.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null collection");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new DistinctConditionalSubscriber<T, K, C>((Fuseable.ConditionalSubscriber)actual, collection, this.keyExtractor, this.distinctPredicate, this.cleanupCallback));
        } else {
            this.source.subscribe(new DistinctSubscriber<T, K, C>(actual, collection, this.keyExtractor, this.distinctPredicate, this.cleanupCallback));
        }
    }

    static final class DistinctFuseableSubscriber<T, K, C>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final CoreSubscriber<? super T> actual;
        final C collection;
        final Function<? super T, ? extends K> keyExtractor;
        final BiPredicate<C, K> distinctPredicate;
        final Consumer<C> cleanupCallback;
        Fuseable.QueueSubscription<T> qs;
        boolean done;
        int sourceMode;

        DistinctFuseableSubscriber(CoreSubscriber<? super T> actual, C collection, Function<? super T, ? extends K> keyExtractor, BiPredicate<C, K> predicate, Consumer<C> callback) {
            this.actual = actual;
            this.collection = collection;
            this.keyExtractor = keyExtractor;
            this.distinctPredicate = predicate;
            this.cleanupCallback = callback;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.qs, s)) {
                this.qs = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.qs.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            K k;
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
                return true;
            }
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.qs, e, t, this.actual.currentContext()));
                return true;
            }
            try {
                b = this.distinctPredicate.test(this.collection, k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.qs, e, t, this.actual.currentContext()));
                return true;
            }
            if (b) {
                this.actual.onNext(t);
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.cleanupCallback.accept(this.collection);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.cleanupCallback.accept(this.collection);
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.qs.request(n);
        }

        @Override
        public void cancel() {
            this.qs.cancel();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            this.sourceMode = m = this.qs.requestFusion(requestedMode);
            return m;
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.qs;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        @Nullable
        public T poll() {
            Object v;
            K r;
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.qs.poll()) == null) {
                        return null;
                    }
                    K r2 = Objects.requireNonNull(this.keyExtractor.apply(v2), "The keyExtractor returned a null collection");
                    if (this.distinctPredicate.test(this.collection, r2)) {
                        if (dropped != 0L) {
                            this.request(dropped);
                        }
                        return (T)v2;
                    }
                    ++dropped;
                }
            }
            do {
                if ((v = this.qs.poll()) != null) continue;
                return null;
            } while (!this.distinctPredicate.test(this.collection, r = Objects.requireNonNull(this.keyExtractor.apply(v), "The keyExtractor returned a null collection")));
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        public void clear() {
            this.qs.clear();
            this.cleanupCallback.accept(this.collection);
        }

        @Override
        public int size() {
            return this.qs.size();
        }
    }

    static final class DistinctConditionalSubscriber<T, K, C>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final C collection;
        final Function<? super T, ? extends K> keyExtractor;
        final BiPredicate<C, K> distinctPredicate;
        final Consumer<C> cleanupCallback;
        Subscription s;
        boolean done;

        DistinctConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, C collection, Function<? super T, ? extends K> keyExtractor, BiPredicate<C, K> distinctPredicate, Consumer<C> cleanupCallback) {
            this.actual = actual;
            this.collection = collection;
            this.keyExtractor = keyExtractor;
            this.distinctPredicate = distinctPredicate;
            this.cleanupCallback = cleanupCallback;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            boolean b;
            K k;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return;
            }
            try {
                b = this.distinctPredicate.test(this.collection, k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return;
            }
            if (b) {
                this.actual.onNext(t);
            } else {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            K k;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return true;
            }
            try {
                b = this.distinctPredicate.test(this.collection, k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return true;
            }
            return b && this.actual.tryOnNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.cleanupCallback.accept(this.collection);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.cleanupCallback.accept(this.collection);
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }

    static final class DistinctSubscriber<T, K, C>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final C collection;
        final Function<? super T, ? extends K> keyExtractor;
        final BiPredicate<C, K> distinctPredicate;
        final Consumer<C> cleanupCallback;
        Subscription s;
        boolean done;

        DistinctSubscriber(CoreSubscriber<? super T> actual, C collection, Function<? super T, ? extends K> keyExtractor, BiPredicate<C, K> distinctPredicate, Consumer<C> cleanupCallback) {
            this.actual = actual;
            this.collection = collection;
            this.keyExtractor = keyExtractor;
            this.distinctPredicate = distinctPredicate;
            this.cleanupCallback = cleanupCallback;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            K k;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return true;
            }
            try {
                b = this.distinctPredicate.test(this.collection, k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return true;
            }
            if (b) {
                this.actual.onNext(t);
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.cleanupCallback.accept(this.collection);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.cleanupCallback.accept(this.collection);
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }
}

