/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.netty.Utils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WriteBufferingAndExceptionHandler
extends ChannelDuplexHandler {
    private static final Logger logger = Logger.getLogger(WriteBufferingAndExceptionHandler.class.getName());
    private final Queue<ChannelWrite> bufferedWrites = new ArrayDeque<ChannelWrite>();
    private final ChannelHandler next;
    private boolean writing;
    private boolean flushRequested;
    private Throwable failCause;

    WriteBufferingAndExceptionHandler(ChannelHandler next) {
        this.next = Preconditions.checkNotNull(next, "next");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(ctx.name(), null, this.next);
        super.handlerAdded(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (!this.bufferedWrites.isEmpty()) {
            Status status = Status.INTERNAL.withDescription("Buffer removed before draining writes");
            this.failWrites(status.asRuntimeException());
        }
        super.handlerRemoved(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        Status status = Status.UNAVAILABLE.withDescription("Connection closed while performing protocol negotiation for " + ctx.pipeline().names());
        this.failWrites(status.asRuntimeException());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        assert (cause != null);
        Throwable previousFailure = this.failCause;
        Status status = Utils.statusFromThrowable(cause);
        this.failWrites(status.asRuntimeException());
        if (ctx.channel().isActive() && previousFailure == null) {
            ctx.close();
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.failCause != null) {
            promise.setFailure(this.failCause);
            ReferenceCountUtil.release(msg);
        } else {
            this.bufferedWrites.add(new ChannelWrite(msg, promise));
        }
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        super.connect(ctx, remoteAddress, localAddress, promise);
        final class ConnectListener
        implements ChannelFutureListener {
            ConnectListener() {
            }

            @Override
            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    WriteBufferingAndExceptionHandler.this.failWrites(future.cause());
                }
            }
        }
        promise.addListener(new ConnectListener());
    }

    @Override
    public void flush(ChannelHandlerContext ctx) {
        this.flushRequested = true;
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
        Status status = Status.UNAVAILABLE.withDescription("Connection closing while performing protocol negotiation for " + ctx.pipeline().names());
        this.failWrites(status.asRuntimeException());
        super.close(ctx, future);
    }

    final void writeBufferedAndRemove(ChannelHandlerContext ctx) {
        if (!ctx.channel().isActive() || this.writing) {
            return;
        }
        this.writing = true;
        while (!this.bufferedWrites.isEmpty()) {
            ChannelWrite write = this.bufferedWrites.poll();
            ctx.write(write.msg, write.promise);
        }
        if (this.flushRequested) {
            ctx.flush();
        }
        ctx.pipeline().remove(this);
    }

    private void failWrites(Throwable cause) {
        if (this.failCause == null) {
            this.failCause = cause;
        } else {
            logger.log(Level.FINE, "Ignoring duplicate failure", cause);
        }
        while (!this.bufferedWrites.isEmpty()) {
            ChannelWrite write = this.bufferedWrites.poll();
            write.promise.setFailure(cause);
            ReferenceCountUtil.release(write.msg);
        }
    }

    private static final class ChannelWrite {
        final Object msg;
        final ChannelPromise promise;

        ChannelWrite(Object msg, ChannelPromise promise) {
            this.msg = msg;
            this.promise = promise;
        }
    }
}

