/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.util.List;

final class PickFirstLoadBalancer
extends LoadBalancer {
    private final LoadBalancer.Helper helper;
    private LoadBalancer.Subchannel subchannel;

    PickFirstLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
    }

    @Override
    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
        if (this.subchannel == null) {
            this.subchannel = this.helper.createSubchannel(servers, Attributes.EMPTY);
            this.helper.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withSubchannel(this.subchannel)));
            this.subchannel.requestConnection();
        } else {
            this.helper.updateSubchannelAddresses(this.subchannel, servers);
        }
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.subchannel != null) {
            this.subchannel.shutdown();
            this.subchannel = null;
        }
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(error)));
    }

    @Override
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        LoadBalancer.SubchannelPicker picker;
        ConnectivityState currentState = stateInfo.getState();
        if (subchannel != this.subchannel || currentState == ConnectivityState.SHUTDOWN) {
            return;
        }
        switch (currentState) {
            case IDLE: {
                picker = new RequestConnectionPicker(subchannel);
                break;
            }
            case CONNECTING: {
                picker = new Picker(LoadBalancer.PickResult.withNoResult());
                break;
            }
            case READY: {
                picker = new Picker(LoadBalancer.PickResult.withSubchannel(subchannel));
                break;
            }
            case TRANSIENT_FAILURE: {
                picker = new Picker(LoadBalancer.PickResult.withError(stateInfo.getStatus()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported state:" + (Object)((Object)currentState));
            }
        }
        this.helper.updateBalancingState(currentState, picker);
    }

    @Override
    public void shutdown() {
        if (this.subchannel != null) {
            this.subchannel.shutdown();
        }
    }

    private static final class RequestConnectionPicker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.Subchannel subchannel;

        RequestConnectionPicker(LoadBalancer.Subchannel subchannel) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            this.subchannel.requestConnection();
            return LoadBalancer.PickResult.withNoResult();
        }

        @Override
        public void requestConnection() {
            this.subchannel.requestConnection();
        }
    }

    private static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;

        Picker(LoadBalancer.PickResult result) {
            this.result = Preconditions.checkNotNull(result, "result");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }
    }
}

