/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.rxgrpc.stub;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.RxClientStreamObserverAndPublisher;
import com.salesforce.rxgrpc.stub.RxSubscriberAndClientProducer;
import com.salesforce.rxgrpc.stub.SubscribeOnlyOnceSingleOperator;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.functions.Consumer;
import org.reactivestreams.Publisher;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <TRequest, TResponse> Single<TResponse> oneToOne(final Single<TRequest> rxRequest, final BiConsumer<TRequest, StreamObserver<TResponse>> delegate) {
        try {
            return Single.create(new SingleOnSubscribe<TResponse>(){

                @Override
                public void subscribe(final SingleEmitter<TResponse> emitter) {
                    rxRequest.subscribe(new Consumer<TRequest>(){

                        @Override
                        public void accept(TRequest request) {
                            delegate.accept(request, new StreamObserver<TResponse>(){

                                @Override
                                public void onNext(TResponse tResponse) {
                                    emitter.onSuccess(tResponse);
                                }

                                @Override
                                public void onError(Throwable throwable) {
                                    emitter.onError(throwable);
                                }

                                @Override
                                public void onCompleted() {
                                }
                            });
                        }
                    }, (Consumer<Throwable>)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable t) {
                            emitter.onError(t);
                        }
                    });
                }
            }).lift(new SubscribeOnlyOnceSingleOperator());
        }
        catch (Throwable throwable) {
            return Single.error(throwable);
        }
    }

    public static <TRequest, TResponse> Flowable<TResponse> oneToMany(Single<TRequest> rxRequest, final BiConsumer<TRequest, StreamObserver<TResponse>> delegate) {
        try {
            return rxRequest.flatMapPublisher(new io.reactivex.functions.Function<TRequest, Publisher<? extends TResponse>>(){

                @Override
                public Publisher<? extends TResponse> apply(TRequest request) {
                    RxClientStreamObserverAndPublisher consumerStreamObserver = new RxClientStreamObserverAndPublisher(null);
                    delegate.accept(request, consumerStreamObserver);
                    return consumerStreamObserver;
                }
            });
        }
        catch (Throwable throwable) {
            return Flowable.error(throwable);
        }
    }

    public static <TRequest, TResponse> Single<TResponse> manyToOne(Flowable<TRequest> flowableSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate) {
        try {
            final RxSubscriberAndClientProducer subscriberAndGRPCProducer = flowableSource.subscribeWith(new RxSubscriberAndClientProducer());
            RxClientStreamObserverAndPublisher observerAndPublisher = new RxClientStreamObserverAndPublisher(new com.salesforce.reactivegrpc.common.Consumer<CallStreamObserver<?>>(){

                @Override
                public void accept(CallStreamObserver<?> observer) {
                    subscriberAndGRPCProducer.subscribe(observer);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    subscriberAndGRPCProducer.cancel();
                }
            });
            delegate.apply(observerAndPublisher);
            return Flowable.fromPublisher(observerAndPublisher).singleOrError();
        }
        catch (Throwable throwable) {
            return Single.error(throwable);
        }
    }

    public static <TRequest, TResponse> Flowable<TResponse> manyToMany(Flowable<TRequest> flowableSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate) {
        try {
            final RxSubscriberAndClientProducer subscriberAndGRPCProducer = flowableSource.subscribeWith(new RxSubscriberAndClientProducer());
            RxClientStreamObserverAndPublisher observerAndPublisher = new RxClientStreamObserverAndPublisher(new com.salesforce.reactivegrpc.common.Consumer<CallStreamObserver<?>>(){

                @Override
                public void accept(CallStreamObserver<?> observer) {
                    subscriberAndGRPCProducer.subscribe(observer);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    subscriberAndGRPCProducer.cancel();
                }
            });
            delegate.apply(observerAndPublisher);
            return Flowable.fromPublisher(observerAndPublisher);
        }
        catch (Throwable throwable) {
            return Flowable.error(throwable);
        }
    }
}

