/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import com.salesforce.reactorgrpc.stub.ReactorClientStreamObserverAndPublisher;
import com.salesforce.reactorgrpc.stub.ReactorSubscriberAndClientProducer;
import com.salesforce.reactorgrpc.stub.SubscribeOnlyOnceLifter;
import io.grpc.stub.StreamObserver;
import java.util.function.BiConsumer;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <TRequest, TResponse> Mono<TResponse> oneToOne(Mono<TRequest> monoSource, BiConsumer<TRequest, StreamObserver<TResponse>> delegate) {
        try {
            return Mono.create(emitter -> monoSource.subscribe(request -> delegate.accept(request, new StreamObserver<TResponse>((MonoSink)emitter){
                final /* synthetic */ MonoSink val$emitter;
                {
                    this.val$emitter = monoSink;
                }

                @Override
                public void onNext(TResponse tResponse) {
                    this.val$emitter.success(tResponse);
                }

                @Override
                public void onError(Throwable throwable) {
                    this.val$emitter.error(throwable);
                }

                @Override
                public void onCompleted() {
                }
            }), emitter::error)).transform(Operators.lift(new SubscribeOnlyOnceLifter()));
        }
        catch (Throwable throwable) {
            return Mono.error(throwable);
        }
    }

    public static <TRequest, TResponse> Flux<TResponse> oneToMany(Mono<TRequest> monoSource, BiConsumer<TRequest, StreamObserver<TResponse>> delegate) {
        try {
            return monoSource.flatMapMany(request -> {
                ReactorClientStreamObserverAndPublisher consumerStreamObserver = new ReactorClientStreamObserverAndPublisher(null);
                delegate.accept(request, consumerStreamObserver);
                return consumerStreamObserver;
            });
        }
        catch (Throwable throwable) {
            return Flux.error(throwable);
        }
    }

    public static <TRequest, TResponse> Mono<TResponse> manyToOne(Flux<TRequest> fluxSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate) {
        try {
            ReactorSubscriberAndClientProducer subscriberAndGRPCProducer = fluxSource.subscribeWith(new ReactorSubscriberAndClientProducer());
            ReactorClientStreamObserverAndPublisher observerAndPublisher = new ReactorClientStreamObserverAndPublisher(s -> subscriberAndGRPCProducer.subscribe(s), subscriberAndGRPCProducer::cancel);
            delegate.apply(observerAndPublisher);
            return Flux.from(observerAndPublisher).singleOrEmpty();
        }
        catch (Throwable throwable) {
            return Mono.error(throwable);
        }
    }

    public static <TRequest, TResponse> Flux<TResponse> manyToMany(Flux<TRequest> fluxSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate) {
        try {
            ReactorSubscriberAndClientProducer subscriberAndGRPCProducer = fluxSource.subscribeWith(new ReactorSubscriberAndClientProducer());
            ReactorClientStreamObserverAndPublisher observerAndPublisher = new ReactorClientStreamObserverAndPublisher(s -> subscriberAndGRPCProducer.subscribe(s), subscriberAndGRPCProducer::cancel);
            delegate.apply(observerAndPublisher);
            return Flux.from(observerAndPublisher);
        }
        catch (Throwable throwable) {
            return Flux.error(throwable);
        }
    }
}

