/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh.proto;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.reactivegrpc.jmh.proto.Control;
import com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc;
import com.salesforce.rxgrpc.stub.ClientCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import io.reactivex.Single;

public final class RxWorkerServiceGrpc {
    private static final int METHODID_RUN_SERVER = 0;
    private static final int METHODID_RUN_CLIENT = 1;
    private static final int METHODID_CORE_COUNT = 2;
    private static final int METHODID_QUIT_WORKER = 3;

    private RxWorkerServiceGrpc() {
    }

    public static RxWorkerServiceStub newRxStub(Channel channel) {
        return new RxWorkerServiceStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final WorkerServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(WorkerServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Control.CoreRequest)request, responseObserver, new Function<Single<Control.CoreRequest>, Single<Control.CoreResponse>>(){

                        @Override
                        public Single<Control.CoreResponse> apply(Single<Control.CoreRequest> single) {
                            return serviceImpl.coreCount(single);
                        }
                    });
                    break;
                }
                case 3: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Control.Void)request, responseObserver, new Function<Single<Control.Void>, Single<Control.Void>>(){

                        @Override
                        public Single<Control.Void> apply(Single<Control.Void> single) {
                            return serviceImpl.quitWorker(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::runServer);
                }
                case 1: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::runClient);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class WorkerServiceImplBase
    implements BindableService {
        public Flowable<Control.ServerStatus> runServer(Flowable<Control.ServerArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<Control.ClientStatus> runClient(Flowable<Control.ClientArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Control.CoreResponse> coreCount(Single<Control.CoreRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Control.Void> quitWorker(Single<Control.Void> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(WorkerServiceGrpc.getServiceDescriptor()).addMethod(WorkerServiceGrpc.getRunServerMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0))).addMethod(WorkerServiceGrpc.getRunClientMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(WorkerServiceGrpc.getCoreCountMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(WorkerServiceGrpc.getQuitWorkerMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }
    }

    public static final class RxWorkerServiceStub
    extends AbstractStub<RxWorkerServiceStub> {
        private WorkerServiceGrpc.WorkerServiceStub delegateStub;

        private RxWorkerServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = WorkerServiceGrpc.newStub(channel);
        }

        private RxWorkerServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = WorkerServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected RxWorkerServiceStub build(Channel channel, CallOptions callOptions) {
            return new RxWorkerServiceStub(channel, callOptions);
        }

        public Flowable<Control.ServerStatus> runServer(Flowable<Control.ServerArgs> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, new Function<StreamObserver<Control.ServerStatus>, StreamObserver<Control.ServerArgs>>(){

                @Override
                public StreamObserver<Control.ServerArgs> apply(StreamObserver<Control.ServerStatus> observer) {
                    return delegateStub.runServer(observer);
                }
            });
        }

        public Flowable<Control.ClientStatus> runClient(Flowable<Control.ClientArgs> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, new Function<StreamObserver<Control.ClientStatus>, StreamObserver<Control.ClientArgs>>(){

                @Override
                public StreamObserver<Control.ClientArgs> apply(StreamObserver<Control.ClientStatus> observer) {
                    return delegateStub.runClient(observer);
                }
            });
        }

        public Single<Control.CoreResponse> coreCount(Single<Control.CoreRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, new BiConsumer<Control.CoreRequest, StreamObserver<Control.CoreResponse>>(){

                @Override
                public void accept(Control.CoreRequest request, StreamObserver<Control.CoreResponse> observer) {
                    delegateStub.coreCount(request, observer);
                }
            });
        }

        public Single<Control.Void> quitWorker(Single<Control.Void> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, new BiConsumer<Control.Void, StreamObserver<Control.Void>>(){

                @Override
                public void accept(Control.Void request, StreamObserver<Control.Void> observer) {
                    delegateStub.quitWorker(request, observer);
                }
            });
        }

        public Single<Control.CoreResponse> coreCount(Control.CoreRequest rxRequest) {
            return ClientCalls.oneToOne(Single.just(rxRequest), new BiConsumer<Control.CoreRequest, StreamObserver<Control.CoreResponse>>(){

                @Override
                public void accept(Control.CoreRequest request, StreamObserver<Control.CoreResponse> observer) {
                    delegateStub.coreCount(request, observer);
                }
            });
        }

        public Single<Control.Void> quitWorker(Control.Void rxRequest) {
            return ClientCalls.oneToOne(Single.just(rxRequest), new BiConsumer<Control.Void, StreamObserver<Control.Void>>(){

                @Override
                public void accept(Control.Void request, StreamObserver<Control.Void> observer) {
                    delegateStub.quitWorker(request, observer);
                }
            });
        }
    }
}

