/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh.proto;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.reactivegrpc.jmh.proto.BenchmarkServiceGrpc;
import com.salesforce.reactivegrpc.jmh.proto.Messages;
import com.salesforce.rxgrpc.stub.ClientCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import io.reactivex.Single;

public final class RxBenchmarkServiceGrpc {
    private static final int METHODID_UNARY_CALL = 0;
    private static final int METHODID_STREAMING_CALL = 1;
    private static final int METHODID_STREAMING_FROM_CLIENT = 2;
    private static final int METHODID_STREAMING_FROM_SERVER = 3;
    private static final int METHODID_STREAMING_BOTH_WAYS = 4;

    private RxBenchmarkServiceGrpc() {
    }

    public static RxBenchmarkServiceStub newRxStub(Channel channel) {
        return new RxBenchmarkServiceStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final BenchmarkServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(BenchmarkServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Messages.SimpleRequest)request, responseObserver, new Function<Single<Messages.SimpleRequest>, Single<Messages.SimpleResponse>>(){

                        @Override
                        public Single<Messages.SimpleResponse> apply(Single<Messages.SimpleRequest> single) {
                            return serviceImpl.unaryCall(single);
                        }
                    });
                    break;
                }
                case 3: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToMany((Messages.SimpleRequest)request, responseObserver, new Function<Single<Messages.SimpleRequest>, Flowable<Messages.SimpleResponse>>(){

                        @Override
                        public Flowable<Messages.SimpleResponse> apply(Single<Messages.SimpleRequest> single) {
                            return serviceImpl.streamingFromServer(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::streamingCall);
                }
                case 2: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToOne(responseObserver, this.serviceImpl::streamingFromClient);
                }
                case 4: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::streamingBothWays);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class BenchmarkServiceImplBase
    implements BindableService {
        public Single<Messages.SimpleResponse> unaryCall(Single<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<Messages.SimpleResponse> streamingCall(Flowable<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Messages.SimpleResponse> streamingFromClient(Flowable<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<Messages.SimpleResponse> streamingFromServer(Single<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<Messages.SimpleResponse> streamingBothWays(Flowable<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(BenchmarkServiceGrpc.getServiceDescriptor()).addMethod(BenchmarkServiceGrpc.getUnaryCallMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(BenchmarkServiceGrpc.getStreamingCallMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(BenchmarkServiceGrpc.getStreamingFromClientMethod(), ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 2))).addMethod(BenchmarkServiceGrpc.getStreamingFromServerMethod(), ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 3))).addMethod(BenchmarkServiceGrpc.getStreamingBothWaysMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 4))).build();
        }
    }

    public static final class RxBenchmarkServiceStub
    extends AbstractStub<RxBenchmarkServiceStub> {
        private BenchmarkServiceGrpc.BenchmarkServiceStub delegateStub;

        private RxBenchmarkServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = BenchmarkServiceGrpc.newStub(channel);
        }

        private RxBenchmarkServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = BenchmarkServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected RxBenchmarkServiceStub build(Channel channel, CallOptions callOptions) {
            return new RxBenchmarkServiceStub(channel, callOptions);
        }

        public Single<Messages.SimpleResponse> unaryCall(Single<Messages.SimpleRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, new BiConsumer<Messages.SimpleRequest, StreamObserver<Messages.SimpleResponse>>(){

                @Override
                public void accept(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> observer) {
                    delegateStub.unaryCall(request, observer);
                }
            });
        }

        public Flowable<Messages.SimpleResponse> streamingCall(Flowable<Messages.SimpleRequest> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, new Function<StreamObserver<Messages.SimpleResponse>, StreamObserver<Messages.SimpleRequest>>(){

                @Override
                public StreamObserver<Messages.SimpleRequest> apply(StreamObserver<Messages.SimpleResponse> observer) {
                    return delegateStub.streamingCall(observer);
                }
            });
        }

        public Single<Messages.SimpleResponse> streamingFromClient(Flowable<Messages.SimpleRequest> rxRequest) {
            return ClientCalls.manyToOne(rxRequest, new Function<StreamObserver<Messages.SimpleResponse>, StreamObserver<Messages.SimpleRequest>>(){

                @Override
                public StreamObserver<Messages.SimpleRequest> apply(StreamObserver<Messages.SimpleResponse> observer) {
                    return delegateStub.streamingFromClient(observer);
                }
            });
        }

        public Flowable<Messages.SimpleResponse> streamingFromServer(Single<Messages.SimpleRequest> rxRequest) {
            return ClientCalls.oneToMany(rxRequest, new BiConsumer<Messages.SimpleRequest, StreamObserver<Messages.SimpleResponse>>(){

                @Override
                public void accept(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> observer) {
                    delegateStub.streamingFromServer(request, observer);
                }
            });
        }

        public Flowable<Messages.SimpleResponse> streamingBothWays(Flowable<Messages.SimpleRequest> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, new Function<StreamObserver<Messages.SimpleResponse>, StreamObserver<Messages.SimpleRequest>>(){

                @Override
                public StreamObserver<Messages.SimpleRequest> apply(StreamObserver<Messages.SimpleResponse> observer) {
                    return delegateStub.streamingBothWays(observer);
                }
            });
        }

        public Single<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest rxRequest) {
            return ClientCalls.oneToOne(Single.just(rxRequest), new BiConsumer<Messages.SimpleRequest, StreamObserver<Messages.SimpleResponse>>(){

                @Override
                public void accept(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> observer) {
                    delegateStub.unaryCall(request, observer);
                }
            });
        }

        public Flowable<Messages.SimpleResponse> streamingFromServer(Messages.SimpleRequest rxRequest) {
            return ClientCalls.oneToMany(Single.just(rxRequest), new BiConsumer<Messages.SimpleRequest, StreamObserver<Messages.SimpleResponse>>(){

                @Override
                public void accept(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> observer) {
                    delegateStub.streamingFromServer(request, observer);
                }
            });
        }
    }
}

