/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh.proto;

import com.salesforce.reactivegrpc.jmh.proto.Control;
import com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc;
import com.salesforce.reactorgrpc.stub.ClientCalls;
import com.salesforce.reactorgrpc.stub.ServerCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactorWorkerServiceGrpc {
    private static final int METHODID_RUN_SERVER = 0;
    private static final int METHODID_RUN_CLIENT = 1;
    private static final int METHODID_CORE_COUNT = 2;
    private static final int METHODID_QUIT_WORKER = 3;

    private ReactorWorkerServiceGrpc() {
    }

    public static ReactorWorkerServiceStub newReactorStub(Channel channel) {
        return new ReactorWorkerServiceStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final WorkerServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(WorkerServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    ServerCalls.oneToOne((Control.CoreRequest)request, responseObserver, this.serviceImpl::coreCount);
                    break;
                }
                case 3: {
                    ServerCalls.oneToOne((Control.Void)request, responseObserver, this.serviceImpl::quitWorker);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::runServer);
                }
                case 1: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::runClient);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class WorkerServiceImplBase
    implements BindableService {
        public Flux<Control.ServerStatus> runServer(Flux<Control.ServerArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flux<Control.ClientStatus> runClient(Flux<Control.ClientArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<Control.CoreResponse> coreCount(Mono<Control.CoreRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<Control.Void> quitWorker(Mono<Control.Void> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(WorkerServiceGrpc.getServiceDescriptor()).addMethod(WorkerServiceGrpc.getRunServerMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0))).addMethod(WorkerServiceGrpc.getRunClientMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(WorkerServiceGrpc.getCoreCountMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(WorkerServiceGrpc.getQuitWorkerMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }
    }

    public static final class ReactorWorkerServiceStub
    extends AbstractStub<ReactorWorkerServiceStub> {
        private WorkerServiceGrpc.WorkerServiceStub delegateStub;

        private ReactorWorkerServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = WorkerServiceGrpc.newStub(channel);
        }

        private ReactorWorkerServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = WorkerServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected ReactorWorkerServiceStub build(Channel channel, CallOptions callOptions) {
            return new ReactorWorkerServiceStub(channel, callOptions);
        }

        public Flux<Control.ServerStatus> runServer(Flux<Control.ServerArgs> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::runServer);
        }

        public Flux<Control.ClientStatus> runClient(Flux<Control.ClientArgs> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::runClient);
        }

        public Mono<Control.CoreResponse> coreCount(Mono<Control.CoreRequest> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::coreCount);
        }

        public Mono<Control.Void> quitWorker(Mono<Control.Void> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::quitWorker);
        }

        public Mono<Control.CoreResponse> coreCount(Control.CoreRequest reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::coreCount);
        }

        public Mono<Control.Void> quitWorker(Control.Void reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::quitWorker);
        }
    }
}

