/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh;

import com.salesforce.reactivegrpc.jmh.BenchmarkGRpcServerServiceImpl;
import com.salesforce.reactivegrpc.jmh.PerfObserver;
import com.salesforce.reactivegrpc.jmh.proto.BenchmarkServiceGrpc;
import com.salesforce.reactivegrpc.jmh.proto.Messages;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@Warmup(iterations=10)
@Measurement(iterations=10, time=10, timeUnit=TimeUnit.SECONDS)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@State(value=Scope.Benchmark)
public class ReferenceGRpcBenchmark {
    static final Messages.SimpleRequest REQUEST = Messages.SimpleRequest.getDefaultInstance();
    static final Messages.SimpleRequest[] ARRAY_REQUEST = new Messages.SimpleRequest[100000];
    private Server gRpcServer;
    private ManagedChannel gRpcChannel;
    private BenchmarkServiceGrpc.BenchmarkServiceStub gRpcClient;

    @Setup
    public void setup() throws IOException {
        System.out.println("---------- SETUP ONCE -------------");
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
        this.gRpcServer = ((InProcessServerBuilder)InProcessServerBuilder.forName("benchmark-gRpcServer").scheduledExecutorService(scheduledExecutorService).addService(new BenchmarkGRpcServerServiceImpl(100000))).build().start();
        this.gRpcChannel = InProcessChannelBuilder.forName("benchmark-gRpcServer").build();
        this.gRpcClient = BenchmarkServiceGrpc.newStub(this.gRpcChannel);
    }

    @TearDown
    public void tearDown() throws InterruptedException {
        System.out.println("---------- TEAR DOWN ONCE -------------");
        this.gRpcServer.shutdownNow();
        this.gRpcChannel.shutdownNow();
        this.gRpcServer.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        this.gRpcChannel.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    @Benchmark
    public Object gRpcUnaryCall(Blackhole blackhole) throws InterruptedException {
        PerfObserver observer = new PerfObserver(blackhole);
        this.gRpcClient.unaryCall(REQUEST, observer);
        observer.latch.await();
        return observer;
    }

    @Benchmark
    public Object gRpcServerStreamingCall(Blackhole blackhole) throws InterruptedException {
        PerfObserver observer = new PerfObserver(blackhole);
        this.gRpcClient.streamingFromServer(REQUEST, observer);
        observer.latch.await();
        return observer;
    }

    @Benchmark
    public Object gRpcClientStreamingCall(Blackhole blackhole) throws InterruptedException {
        PerfObserver observer = new PerfObserver(blackhole);
        StreamObserver<Messages.SimpleRequest> sender = this.gRpcClient.streamingFromClient(observer);
        for (Messages.SimpleRequest request : ARRAY_REQUEST) {
            sender.onNext(request);
        }
        sender.onCompleted();
        observer.latch.await();
        return observer;
    }

    @Benchmark
    public Object gRpcBothWaysStreamingCall(Blackhole blackhole) throws InterruptedException {
        PerfObserver observer = new PerfObserver(blackhole){
            private boolean done;

            @Override
            public void beforeStart(ClientCallStreamObserver<Messages.SimpleRequest> sender) {
                sender.setOnReadyHandler(() -> {
                    if (this.done) {
                        return;
                    }
                    for (Messages.SimpleRequest request : ARRAY_REQUEST) {
                        sender.onNext(request);
                    }
                    sender.onCompleted();
                    this.done = true;
                });
                super.beforeStart(this.observer);
            }
        };
        this.gRpcClient.streamingFromClient(observer);
        observer.latch.await();
        return observer;
    }

    static {
        Arrays.fill(ARRAY_REQUEST, Messages.SimpleRequest.getDefaultInstance());
    }
}

