/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh;

import com.salesforce.reactivegrpc.jmh.proto.BenchmarkServiceGrpc;
import com.salesforce.reactivegrpc.jmh.proto.Messages;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.List;

public class BenchmarkGRpcServerServiceImpl
extends BenchmarkServiceGrpc.BenchmarkServiceImplBase {
    private final Messages.SimpleResponse response;
    private final List<Messages.SimpleResponse> responses;

    public BenchmarkGRpcServerServiceImpl(int times) {
        Object[] array = new Messages.SimpleResponse[times];
        Arrays.fill(array, Messages.SimpleResponse.getDefaultInstance());
        this.responses = Arrays.asList(array);
        this.response = Messages.SimpleResponse.getDefaultInstance();
    }

    @Override
    public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
        responseObserver.onNext(this.response);
        responseObserver.onCompleted();
    }

    @Override
    public void streamingFromServer(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
        ServerCallStreamObserver callStreamObserver = (ServerCallStreamObserver)responseObserver;
        for (Messages.SimpleResponse response : this.responses) {
            if (callStreamObserver.isCancelled()) {
                return;
            }
            callStreamObserver.onNext(response);
        }
        if (!callStreamObserver.isCancelled()) {
            callStreamObserver.onCompleted();
        }
    }

    @Override
    public StreamObserver<Messages.SimpleRequest> streamingFromClient(final StreamObserver<Messages.SimpleResponse> responseObserver) {
        return new StreamObserver<Messages.SimpleRequest>(){

            @Override
            public void onNext(Messages.SimpleRequest value) {
            }

            @Override
            public void onError(Throwable t) {
                responseObserver.onError(t);
            }

            @Override
            public void onCompleted() {
                responseObserver.onNext(BenchmarkGRpcServerServiceImpl.this.response);
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    public StreamObserver<Messages.SimpleRequest> streamingBothWays(StreamObserver<Messages.SimpleResponse> responseObserver) {
        ServerCallStreamObserver callStreamObserver = (ServerCallStreamObserver)responseObserver;
        callStreamObserver.setOnReadyHandler(() -> {
            for (Messages.SimpleResponse response : this.responses) {
                if (callStreamObserver.isCancelled()) {
                    return;
                }
                callStreamObserver.onNext(response);
            }
            if (!callStreamObserver.isCancelled()) {
                callStreamObserver.onCompleted();
            }
        });
        return new StreamObserver<Messages.SimpleRequest>(){

            @Override
            public void onNext(Messages.SimpleRequest value) {
            }

            @Override
            public void onError(Throwable t) {
            }

            @Override
            public void onCompleted() {
            }
        };
    }
}

